/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.load.message;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.hive.metastore.messaging.AbortTxnMessage;
import org.apache.hadoop.hive.metastore.utils.StringUtils;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.load.message.AbstractMessageHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.message.MessageHandler;
import org.apache.hadoop.hive.ql.plan.ReplTxnWork;

public class AbortTxnHandler
extends AbstractMessageHandler {
    @Override
    public List<Task<?>> handle(MessageHandler.Context context) throws SemanticException {
        if (!AcidUtils.isAcidEnabled(context.hiveConf)) {
            context.log.error("Cannot load transaction events as acid is not enabled");
            throw new SemanticException("Cannot load transaction events as acid is not enabled");
        }
        AbortTxnMessage msg = this.deserializer.getAbortTxnMessage(context.dmd.getPayload());
        List writeIds = msg.getWriteIds();
        List<String> databases = Optional.ofNullable(msg.getDbsUpdated()).orElse(Collections.emptyList()).stream().map(StringUtils::normalizeIdentifier).toList();
        if (databases.contains(context.dbName) && writeIds != null && !writeIds.isEmpty()) {
            context.getMetricCollector().setSrcTimeInProgress(msg.getTimestamp());
        }
        Task<ReplTxnWork> abortTxnTask = TaskFactory.get(new ReplTxnWork(HiveUtils.getReplPolicy(context.dbName), context.dbName, null, msg.getTxnId(), ReplTxnWork.OperationType.REPL_ABORT_TXN, context.eventOnlyReplicationSpec(), context.getDumpDirectory(), context.getMetricCollector()), context.hiveConf);
        if (!context.isDbNameEmpty()) {
            this.updatedMetadata.set(context.dmd.getEventTo().toString(), context.dbName, null, null);
        }
        context.log.debug("Added Abort txn task : {}", (Object)abortTxnTask.getId());
        return Collections.singletonList(abortTxnTask);
    }
}

