/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.IOConstants;
import org.apache.hadoop.hive.ql.io.StorageFormatDescriptor;
import org.apache.hadoop.hive.ql.io.StorageFormatFactory;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageFormat {
    private static final Logger LOG = LoggerFactory.getLogger(StorageFormat.class);
    private static final StorageFormatFactory storageFormatFactory = new StorageFormatFactory();
    private final Configuration conf;
    private String inputFormat;
    private String outputFormat;
    private String storageHandler;
    private String serde;
    private final Map<String, String> serdeProps;

    public StorageFormat(Configuration conf) {
        this.conf = conf;
        this.serdeProps = new HashMap<String, String>();
    }

    public boolean fillStorageFormat(ASTNode child) throws SemanticException {
        switch (child.getToken().getType()) {
            case 1259: {
                if (child.getChildCount() < 2) {
                    throw new SemanticException("Incomplete specification of File Format. You must provide InputFormat, OutputFormat.");
                }
                this.inputFormat = ParseUtils.ensureClassExists(BaseSemanticAnalyzer.unescapeSQLString(child.getChild(0).getText()));
                this.outputFormat = ParseUtils.ensureClassExists(BaseSemanticAnalyzer.unescapeSQLString(child.getChild(1).getText()));
                if (child.getChildCount() != 3) break;
                this.serde = ParseUtils.ensureClassExists(BaseSemanticAnalyzer.unescapeSQLString(child.getChild(2).getText()));
                break;
            }
            case 1237: {
                block11: for (int i = 0; i < child.getChildCount(); ++i) {
                    ASTNode grandChild = (ASTNode)child.getChild(i);
                    switch (grandChild.getToken().getType()) {
                        case 1032: {
                            HiveStorageHandler handler;
                            try {
                                handler = HiveUtils.getStorageHandler(this.conf, this.storageHandler);
                            }
                            catch (HiveException e) {
                                throw new SemanticException("Failed to load storage handler:  " + e.getMessage());
                            }
                            String fileFormatPropertyKey = handler.getFileFormatPropertyKey();
                            if (fileFormatPropertyKey != null) {
                                String fileFormat = grandChild.getChild(0).getText();
                                if (this.serdeProps.containsKey(fileFormatPropertyKey)) {
                                    throw new SemanticException("Provide only one of the following: STORED BY " + fileFormat + " or WITH SERDEPROPERTIES('" + fileFormatPropertyKey + "'='" + fileFormat + "')");
                                }
                                this.serdeProps.put(fileFormatPropertyKey, fileFormat);
                                continue block11;
                            }
                            throw new SemanticException("STORED AS is not supported for storage handler " + handler.getClass().getName());
                        }
                        case 1264: {
                            BaseSemanticAnalyzer.readProps((ASTNode)grandChild.getChild(0), this.serdeProps);
                            continue block11;
                        }
                        default: {
                            this.storageHandler = this.processStorageHandler(grandChild);
                        }
                    }
                }
                break;
            }
            case 1032: {
                if (this.storageHandler != null) {
                    LOG.info("'STORED AS' clause will be ignored, since a default storage handler class is already set: '{}'", (Object)this.storageHandler);
                    break;
                }
                ASTNode grandChild = (ASTNode)child.getChild(0);
                String name = (grandChild == null ? "" : grandChild.getText()).trim().toUpperCase();
                this.processStorageFormat(name);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private String processStorageHandler(ASTNode node) throws SemanticException {
        if (node.getType() == 439) {
            try {
                return ParseUtils.ensureClassExists(BaseSemanticAnalyzer.unescapeSQLString(node.getText()));
            }
            catch (SemanticException e) {
                throw StorageFormat.createUnsupportedStorageHandlerTypeError(node, e);
            }
        }
        if (node.getType() == 24) {
            for (StorageHandlerTypes type : StorageHandlerTypes.NON_DEFAULT_TYPES) {
                if (!type.name().equalsIgnoreCase(node.getText())) continue;
                Objects.requireNonNull(type.className());
                this.inputFormat = type.inputFormat();
                this.outputFormat = type.outputFormat();
                return ParseUtils.ensureClassExists(BaseSemanticAnalyzer.unescapeSQLString(type.className()));
            }
        }
        throw StorageFormat.createUnsupportedStorageHandlerTypeError(node, null);
    }

    private static SemanticException createUnsupportedStorageHandlerTypeError(ASTNode node, Throwable cause) {
        String supportedTypes = StorageHandlerTypes.NON_DEFAULT_TYPES.stream().map(Enum::toString).collect(Collectors.joining(", "));
        return new SemanticException(String.format("The storage handler specified in the STORED BY clause is not recognized: %s. Please use one of the supported types, which are %s, or provide the Fully Qualified Class Name (FQCN) of a valid storage handler.", node.getText(), supportedTypes), cause);
    }

    public void processStorageFormat(String name) throws SemanticException {
        StorageFormatDescriptor descriptor = StorageFormat.getDescriptor(name, "STORED AS clause");
        this.inputFormat = ParseUtils.ensureClassExists(descriptor.getInputFormat());
        this.outputFormat = ParseUtils.ensureClassExists(descriptor.getOutputFormat());
        if (this.serde == null) {
            this.serde = ParseUtils.ensureClassExists(descriptor.getSerde());
        }
        if (this.serde == null) {
            this.serde = name.equalsIgnoreCase("RCFILE") ? ParseUtils.ensureClassExists(HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DEFAULT_RCFILE_SERDE)) : ParseUtils.ensureClassExists(HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DEFAULT_SERDE));
        }
    }

    public void fillDefaultStorageFormat(boolean isExternal, boolean isMaterializedView) throws SemanticException {
        if (this.inputFormat == null && this.storageHandler == null) {
            String defaultFormat;
            String defaultManagedFormat;
            if (isMaterializedView) {
                defaultFormat = defaultManagedFormat = HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_MATERIALIZED_VIEW_FILE_FORMAT);
                this.serde = HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_MATERIALIZED_VIEW_SERDE);
            } else {
                defaultFormat = HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DEFAULT_FILEFORMAT);
                defaultManagedFormat = HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DEFAULT_MANAGED_FILEFORMAT);
            }
            if (!isExternal && !"none".equals(defaultManagedFormat)) {
                defaultFormat = defaultManagedFormat;
            }
            if (StringUtils.isBlank((CharSequence)defaultFormat)) {
                this.inputFormat = IOConstants.TEXTFILE_INPUT;
                this.outputFormat = IOConstants.TEXTFILE_OUTPUT;
            } else {
                this.processStorageFormat(defaultFormat);
                if (defaultFormat.equalsIgnoreCase("RCFILE")) {
                    this.serde = HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DEFAULT_RCFILE_SERDE);
                }
            }
        }
    }

    public void setSerde(String serde) {
        this.serde = serde;
    }

    public String getInputFormat() {
        return this.inputFormat;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public String getStorageHandler() {
        return this.storageHandler;
    }

    public String getSerde() {
        return this.serde;
    }

    public Map<String, String> getSerdeProps() {
        return this.serdeProps;
    }

    public void setStorageHandler(String storageHandlerClass) throws SemanticException {
        this.storageHandler = ParseUtils.ensureClassExists(storageHandlerClass);
    }

    public static StorageFormatDescriptor getDescriptor(String format, String clause) throws SemanticException {
        if (format.isEmpty()) {
            throw new SemanticException("File format in " + clause + " cannot be empty");
        }
        StorageFormatDescriptor descriptor = storageFormatFactory.get(format);
        if (descriptor == null) {
            throw new SemanticException("Unrecognized file format in " + clause + ": '" + format + "'");
        }
        return descriptor;
    }

    public static enum StorageHandlerTypes {
        DEFAULT,
        ICEBERG("'org.apache.iceberg.mr.hive.HiveIcebergStorageHandler'", "org.apache.iceberg.mr.hive.HiveIcebergInputFormat", "org.apache.iceberg.mr.hive.HiveIcebergOutputFormat");

        private static final List<StorageHandlerTypes> NON_DEFAULT_TYPES;
        private final String className;
        private final String inputFormat;
        private final String outputFormat;

        private StorageHandlerTypes() {
            this.className = null;
            this.inputFormat = null;
            this.outputFormat = null;
        }

        private StorageHandlerTypes(String className, String inputFormat, String outputFormat) {
            this.className = className;
            this.inputFormat = inputFormat;
            this.outputFormat = outputFormat;
        }

        public String className() {
            return this.className;
        }

        public String inputFormat() {
            return this.inputFormat;
        }

        public String outputFormat() {
            return this.outputFormat;
        }

        static {
            NON_DEFAULT_TYPES = Arrays.stream(StorageHandlerTypes.values()).filter(type -> type != DEFAULT).collect(Collectors.toList());
        }
    }
}

