/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.QueryProperties;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.AcidExportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.CalcitePlanner;
import org.apache.hadoop.hive.ql.parse.ColumnStatsSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.DeleteSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExecuteStatementAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExplainSQRewriteSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExplainSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ImportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.LoadSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.MergeSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.PrepareStatementAnalyzer;
import org.apache.hadoop.hive.ql.parse.ReplicationSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ScheduledQueryAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.UpdateSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.rewrite.DeleteRewriterFactory;
import org.apache.hadoop.hive.ql.parse.rewrite.MergeRewriterFactory;
import org.apache.hadoop.hive.ql.parse.rewrite.UpdateRewriterFactory;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SemanticAnalyzerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SemanticAnalyzerFactory.class);

    private SemanticAnalyzerFactory() {
        throw new UnsupportedOperationException("SemanticAnalyzerFactory should not be instantiated");
    }

    public static BaseSemanticAnalyzer get(QueryState queryState, ASTNode tree) throws SemanticException {
        BaseSemanticAnalyzer sem = SemanticAnalyzerFactory.getInternal(queryState, tree);
        if (queryState.getHiveOperation() == null) {
            String query = queryState.getQueryString();
            if (query != null && query.length() > 30) {
                query = query.substring(0, 30);
            }
            String msg = "Unknown HiveOperation for query='" + query + "' queryId=" + queryState.getQueryId();
            LOG.debug(msg);
        }
        return sem;
    }

    private static BaseSemanticAnalyzer getInternal(QueryState queryState, ASTNode tree) throws SemanticException {
        if (tree.getToken() == null) {
            throw new RuntimeException("Empty Syntax Tree");
        }
        HiveOperation opType = HiveOperation.operationForToken(tree.getType());
        queryState.setCommandType(opType);
        if (DDLSemanticAnalyzerFactory.handles(tree)) {
            BaseSemanticAnalyzer sem = DDLSemanticAnalyzerFactory.getAnalyzer(tree, queryState);
            QueryProperties queryProperties = sem.getQueryProperties();
            queryProperties.setQueryType(QueryProperties.QueryType.DDL);
            return sem;
        }
        switch (tree.getType()) {
            case 1025: {
                return new ExplainSemanticAnalyzer(queryState);
            }
            case 1026: {
                return new ExplainSQRewriteSemanticAnalyzer(queryState);
            }
            case 1090: {
                return new LoadSemanticAnalyzer(queryState);
            }
            case 1028: {
                if (AcidExportSemanticAnalyzer.isAcidExport(tree)) {
                    return new AcidExportSemanticAnalyzer(queryState);
                }
                return new ExportSemanticAnalyzer(queryState);
            }
            case 1057: {
                return new ImportSemanticAnalyzer(queryState);
            }
            case 1174: {
                return new ReplicationSemanticAnalyzer(queryState);
            }
            case 1175: {
                return new ReplicationSemanticAnalyzer(queryState);
            }
            case 1176: {
                return new ReplicationSemanticAnalyzer(queryState);
            }
            case 906: {
                Tree child = tree.getChild(1);
                assert (child.getType() == 1161);
                queryState.setCommandType(HiveOperation.ALTERVIEW_AS);
                return new SemanticAnalyzer(queryState);
            }
            case 929: {
                return new ColumnStatsSemanticAnalyzer(queryState);
            }
            case 1311: {
                return new UpdateSemanticAnalyzer(queryState, new UpdateRewriterFactory(queryState.getConf()));
            }
            case 992: {
                return new DeleteSemanticAnalyzer(queryState, new DeleteRewriterFactory(queryState.getConf()));
            }
            case 1095: {
                return new MergeSemanticAnalyzer(queryState, new MergeRewriterFactory(queryState.getConf()));
            }
            case 927: 
            case 967: 
            case 1016: {
                return new ScheduledQueryAnalyzer(queryState);
            }
            case 1022: {
                return new ExecuteStatementAnalyzer(queryState);
            }
            case 1140: {
                return new PrepareStatementAnalyzer(queryState);
            }
        }
        SemanticAnalyzer semAnalyzer = HiveConf.getBoolVar((Configuration)queryState.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CBO_ENABLED) ? new CalcitePlanner(queryState) : new SemanticAnalyzer(queryState);
        return semAnalyzer;
    }
}

