/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;

public class PrunedPartitionList {
    private final Table source;
    private final Optional<String> ppListKey;
    private final Set<Partition> partitions;
    private final List<String> referred;
    private final boolean hasUnknowns;

    public PrunedPartitionList(Table source, Set<Partition> partitions, List<String> referred, boolean hasUnknowns) {
        this(source, null, partitions, referred, hasUnknowns);
    }

    public PrunedPartitionList(Table source, String key, Set<Partition> partitions, List<String> referred, boolean hasUnknowns) {
        this.source = Objects.requireNonNull(source);
        this.ppListKey = Optional.ofNullable(key);
        this.referred = Objects.requireNonNull(referred);
        this.partitions = Objects.requireNonNull(partitions);
        this.hasUnknowns = hasUnknowns;
    }

    public Table getSourceTable() {
        return this.source;
    }

    public Optional<String> getKey() {
        return this.ppListKey;
    }

    public Set<Partition> getPartitions() {
        return Collections.unmodifiableSet(this.partitions);
    }

    public List<Partition> getNotDeniedPartns() {
        return Collections.unmodifiableList(new ArrayList<Partition>(this.partitions));
    }

    public boolean hasUnknownPartitions() {
        return this.hasUnknowns;
    }

    public List<String> getReferredPartCols() {
        return Collections.unmodifiableList(this.referred);
    }
}

