/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.listbucketingpruner;

import java.util.Map;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.SemanticNodeProcessor;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.optimizer.PrunerExpressionOperatorFactory;
import org.apache.hadoop.hive.ql.optimizer.PrunerUtils;
import org.apache.hadoop.hive.ql.optimizer.listbucketingpruner.LBExprProcCtx;
import org.apache.hadoop.hive.ql.optimizer.listbucketingpruner.ListBucketingPrunerUtils;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;

public class LBExprProcFactory
extends PrunerExpressionOperatorFactory {
    private LBExprProcFactory() {
    }

    public static ExprNodeDesc genPruner(String tabAlias, ExprNodeDesc pred, Partition part) throws SemanticException {
        LBExprProcCtx lbprCtx = new LBExprProcCtx(tabAlias, part);
        Map<Node, Object> outputMap = PrunerUtils.walkExprTree(pred, lbprCtx, LBExprProcFactory.getColumnProcessor(), LBExprProcFactory.getFieldProcessor(), LBExprProcFactory.getGenericFuncProcessor(), LBExprProcFactory.getDefaultExprProcessor());
        return (ExprNodeDesc)outputMap.get(pred);
    }

    public static SemanticNodeProcessor getColumnProcessor() {
        return new LBPRColumnExprProcessor();
    }

    public static class LBPRColumnExprProcessor
    extends PrunerExpressionOperatorFactory.ColumnExprProcessor {
        @Override
        protected ExprNodeDesc processColumnDesc(NodeProcessorCtx procCtx, ExprNodeColumnDesc cd) {
            LBExprProcCtx ctx = (LBExprProcCtx)procCtx;
            Partition part = ctx.getPart();
            ExprNodeDesc newcd = cd.getTabAlias().equalsIgnoreCase(ctx.getTabAlias()) && this.isPruneForListBucketing(part, cd.getColumn()) ? cd.clone() : new ExprNodeConstantDesc(cd.getTypeInfo(), null);
            return newcd;
        }

        private boolean isPruneForListBucketing(Partition part, String columnName) {
            return ListBucketingPrunerUtils.isListBucketingPart(part) && part.getSkewedColNames().contains(columnName);
        }
    }
}

