/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.graph;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class DiGraph<V, E> {
    private final Map<V, Node<V, E>> nodes = new LinkedHashMap<V, Node<V, E>>();

    public void putEdgeValue(V s, V t, E e) {
        Node<V, E> nodeS = this.nodeOf(s);
        Node<V, E> nodeT = this.nodeOf(t);
        Edge<V, E> edge = new Edge<V, E>(nodeS, nodeT, e);
        nodeS.addEdge(edge);
    }

    public Node<V, E> nodeOf(V s) {
        Node<V, E> node = this.nodes.get(s);
        if (node == null) {
            node = this.newNode(s);
            this.nodes.put((Node<V, E>)s, (Node<Node<V, E>, E>)node);
        }
        return node;
    }

    protected Node<V, E> newNode(V s) {
        return new Node(s);
    }

    public Set<V> nodes() {
        return this.nodes.keySet();
    }

    public Set<V> predecessors(V n) {
        LinkedHashSet ret = new LinkedHashSet();
        Node<V, E> node = this.nodes.get(n);
        if (node == null) {
            return ret;
        }
        for (Edge edge : node.edges) {
            if (!edge.t.v.equals(n)) continue;
            ret.add(edge.s.v);
        }
        return ret;
    }

    public Set<V> successors(V n) {
        LinkedHashSet ret = new LinkedHashSet();
        Node<V, E> node = this.nodes.get(n);
        if (node == null) {
            return ret;
        }
        for (Edge edge : node.edges) {
            if (!edge.s.v.equals(n)) continue;
            ret.add(edge.t.v);
        }
        return ret;
    }

    public Optional<E> getEdge(V s, V t) {
        Node<V, E> node = this.nodes.get(s);
        if (node == null) {
            return Optional.empty();
        }
        for (Edge edge : node.edges) {
            if (!edge.s.v.equals(s) || !edge.t.v.equals(t)) continue;
            return Optional.of(edge.e);
        }
        return Optional.empty();
    }

    public int degree(V n) {
        Node<V, E> node = this.nodes.get(n);
        return node.degree();
    }

    public int inDegree(V n) {
        Node<V, E> node = this.nodes.get(n);
        return node.inDegree();
    }

    public E removeEdge(V s, V t) {
        this.nodeOf(s).removeEdge(s, t);
        return this.nodeOf(t).removeEdge(s, t);
    }

    public void impode(V n, E edge) {
        Set<V> preds = this.predecessors(n);
        Set<V> succ = this.successors(n);
        for (V u : preds) {
            for (V v : succ) {
                this.putEdgeValue(u, v, edge);
            }
        }
        this.delete(n);
    }

    public void delete(V n) {
        Node<V, E> node = this.nodeOf(n);
        HashSet edges = new HashSet(node.edges);
        for (Edge edge : edges) {
            this.removeEdge(edge.s.v, edge.t.v);
        }
        this.nodes.remove(n);
    }

    protected static class Node<V, E> {
        public final Set<Edge<V, E>> edges = new LinkedHashSet<Edge<V, E>>();
        public final V v;

        public Node(V v) {
            this.v = v;
        }

        public void addEdge(Edge<V, E> edge) {
            if (edge.s == this) {
                edge.t.addEdge(edge);
            }
            this.edges.add(edge);
        }

        public E removeEdge(V s, V t) {
            Iterator<Edge<V, E>> it = this.edges.iterator();
            while (it.hasNext()) {
                Edge<V, E> edge = it.next();
                if (!edge.s.v.equals(s) || !edge.t.v.equals(t)) continue;
                it.remove();
                return edge.e;
            }
            return null;
        }

        public int degree() {
            return this.edges.size();
        }

        public int inDegree() {
            Iterator<Edge<V, E>> it = this.edges.iterator();
            int cnt = 0;
            while (it.hasNext()) {
                Edge<V, E> edge = it.next();
                if (edge.t != this) continue;
                ++cnt;
            }
            return cnt;
        }
    }

    protected static class Edge<V, E> {
        public final Node<V, E> s;
        public final Node<V, E> t;
        public final E e;

        public Edge(Node<V, E> s, Node<V, E> t, E e) {
            this.s = s;
            this.t = t;
            this.e = e;
        }
    }
}

