/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.translator;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.nio.charset.Charset;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.ConversionUtil;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.SqlFunctionConverter;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.serde2.typeinfo.BaseCharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;

public class TypeConverter {
    private static final Map<String, SqlFunctionConverter.HiveToken> calciteToHiveTypeNameMap;
    private static final String UNION_FIELD_PREFIX = "$tag_";

    public static RelDataType getType(RelOptCluster cluster, List<ColumnInfo> cInfoLst) {
        RexBuilder rexBuilder = cluster.getRexBuilder();
        RelDataTypeFactory dtFactory = rexBuilder.getTypeFactory();
        LinkedList<RelDataType> fieldTypes = new LinkedList<RelDataType>();
        LinkedList<String> fieldNames = new LinkedList<String>();
        for (ColumnInfo ci : cInfoLst) {
            fieldTypes.add(TypeConverter.convert(ci.getType(), dtFactory));
            fieldNames.add(ci.getInternalName());
        }
        return dtFactory.createStructType(fieldTypes, fieldNames);
    }

    public static RelDataType getType(RelOptCluster cluster, RowResolver rr, List<String> neededCols) {
        RexBuilder rexBuilder = cluster.getRexBuilder();
        RelDataTypeFactory dtFactory = rexBuilder.getTypeFactory();
        RowSchema rs = rr.getRowSchema();
        LinkedList<RelDataType> fieldTypes = new LinkedList<RelDataType>();
        LinkedList<String> fieldNames = new LinkedList<String>();
        for (ColumnInfo ci : rs.getSignature()) {
            if (neededCols != null && !neededCols.contains(ci.getInternalName())) continue;
            fieldTypes.add(TypeConverter.convert(ci.getType(), ci.isNullable(), dtFactory));
            fieldNames.add(ci.getInternalName());
        }
        return dtFactory.createStructType(fieldTypes, fieldNames);
    }

    public static RelDataType convert(TypeInfo type, RelDataTypeFactory dtFactory) {
        return TypeConverter.convert(type, true, dtFactory);
    }

    public static RelDataType convert(TypeInfo type, boolean nullable, RelDataTypeFactory dtFactory) {
        RelDataType convertedType = null;
        switch (type.getCategory()) {
            case PRIMITIVE: {
                convertedType = TypeConverter.convert((PrimitiveTypeInfo)type, nullable, dtFactory);
                break;
            }
            case LIST: {
                convertedType = TypeConverter.convert((ListTypeInfo)type, dtFactory);
                break;
            }
            case MAP: {
                convertedType = TypeConverter.convert((MapTypeInfo)type, dtFactory);
                break;
            }
            case STRUCT: {
                convertedType = TypeConverter.convert((StructTypeInfo)type, dtFactory);
                break;
            }
            case UNION: {
                convertedType = TypeConverter.convert((UnionTypeInfo)type, dtFactory);
            }
        }
        return dtFactory.createTypeWithNullability(convertedType, nullable);
    }

    public static RelDataType convert(PrimitiveTypeInfo type, RelDataTypeFactory dtFactory) {
        return TypeConverter.convert(type, true, dtFactory);
    }

    public static RelDataType convert(PrimitiveTypeInfo type, boolean nullable, RelDataTypeFactory dtFactory) {
        RelDataType convertedType = null;
        switch (type.getPrimitiveCategory()) {
            case VOID: {
                convertedType = dtFactory.createSqlType(SqlTypeName.NULL);
                break;
            }
            case BOOLEAN: {
                convertedType = dtFactory.createSqlType(SqlTypeName.BOOLEAN);
                break;
            }
            case BYTE: {
                convertedType = dtFactory.createSqlType(SqlTypeName.TINYINT);
                break;
            }
            case SHORT: {
                convertedType = dtFactory.createSqlType(SqlTypeName.SMALLINT);
                break;
            }
            case INT: {
                convertedType = dtFactory.createSqlType(SqlTypeName.INTEGER);
                break;
            }
            case LONG: {
                convertedType = dtFactory.createSqlType(SqlTypeName.BIGINT);
                break;
            }
            case FLOAT: {
                convertedType = dtFactory.createSqlType(SqlTypeName.FLOAT);
                break;
            }
            case DOUBLE: {
                convertedType = dtFactory.createSqlType(SqlTypeName.DOUBLE);
                break;
            }
            case STRING: {
                convertedType = dtFactory.createTypeWithCharsetAndCollation(dtFactory.createSqlType(SqlTypeName.VARCHAR, Integer.MAX_VALUE), Charset.forName(ConversionUtil.NATIVE_UTF16_CHARSET_NAME), SqlCollation.IMPLICIT);
                break;
            }
            case DATE: {
                convertedType = dtFactory.createSqlType(SqlTypeName.DATE);
                break;
            }
            case TIMESTAMP: {
                convertedType = dtFactory.createSqlType(SqlTypeName.TIMESTAMP);
                break;
            }
            case TIMESTAMPLOCALTZ: {
                convertedType = dtFactory.createSqlType(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE);
                break;
            }
            case INTERVAL_YEAR_MONTH: {
                convertedType = dtFactory.createSqlIntervalType(new SqlIntervalQualifier(TimeUnit.YEAR, TimeUnit.MONTH, new SqlParserPos(1, 1)));
                break;
            }
            case INTERVAL_DAY_TIME: {
                convertedType = dtFactory.createSqlIntervalType(new SqlIntervalQualifier(TimeUnit.DAY, TimeUnit.SECOND, new SqlParserPos(1, 1)));
                break;
            }
            case BINARY: {
                convertedType = dtFactory.createSqlType(SqlTypeName.BINARY);
                break;
            }
            case DECIMAL: {
                DecimalTypeInfo dtInf = (DecimalTypeInfo)type;
                convertedType = dtFactory.createSqlType(SqlTypeName.DECIMAL, dtInf.precision(), dtInf.scale());
                break;
            }
            case VARCHAR: {
                convertedType = dtFactory.createTypeWithCharsetAndCollation(dtFactory.createSqlType(SqlTypeName.VARCHAR, ((BaseCharTypeInfo)type).getLength()), Charset.forName(ConversionUtil.NATIVE_UTF16_CHARSET_NAME), SqlCollation.IMPLICIT);
                break;
            }
            case CHAR: {
                convertedType = dtFactory.createTypeWithCharsetAndCollation(dtFactory.createSqlType(SqlTypeName.CHAR, ((BaseCharTypeInfo)type).getLength()), Charset.forName(ConversionUtil.NATIVE_UTF16_CHARSET_NAME), SqlCollation.IMPLICIT);
                break;
            }
            case UNKNOWN: {
                convertedType = dtFactory.createSqlType(SqlTypeName.OTHER);
            }
        }
        if (null == convertedType) {
            throw new RuntimeException("Unsupported Type : " + type.getTypeName());
        }
        return dtFactory.createTypeWithNullability(convertedType, nullable);
    }

    public static RelDataType convert(ListTypeInfo lstType, RelDataTypeFactory dtFactory) {
        RelDataType elemType = TypeConverter.convert(lstType.getListElementTypeInfo(), dtFactory);
        return dtFactory.createArrayType(elemType, -1L);
    }

    public static RelDataType convert(MapTypeInfo mapType, RelDataTypeFactory dtFactory) {
        RelDataType keyType = TypeConverter.convert(mapType.getMapKeyTypeInfo(), dtFactory);
        RelDataType valueType = TypeConverter.convert(mapType.getMapValueTypeInfo(), dtFactory);
        return dtFactory.createMapType(keyType, valueType);
    }

    public static RelDataType convert(StructTypeInfo structType, RelDataTypeFactory dtFactory) {
        ArrayList<RelDataType> fTypes = new ArrayList<RelDataType>(structType.getAllStructFieldTypeInfos().size());
        for (TypeInfo ti : structType.getAllStructFieldTypeInfos()) {
            fTypes.add(TypeConverter.convert(ti, dtFactory));
        }
        return dtFactory.createStructType(fTypes, structType.getAllStructFieldNames());
    }

    public static RelDataType convert(UnionTypeInfo unionType, RelDataTypeFactory dtFactory) {
        RelDataTypeFactory.FieldInfoBuilder b = dtFactory.builder();
        for (TypeInfo ti : unionType.getAllUnionObjectTypeInfos()) {
            b.add(UNION_FIELD_PREFIX + b.getFieldCount(), TypeConverter.convert(ti, dtFactory));
        }
        return b.build();
    }

    public static TypeInfo convertLiteralType(RexLiteral literal) {
        return TypeConverter.convertPrimitiveType(literal.getType());
    }

    public static TypeInfo convert(RelDataType rType) {
        if (rType.isStruct()) {
            return TypeConverter.convertStructType(rType);
        }
        if (rType.getComponentType() != null) {
            return TypeConverter.convertListType(rType);
        }
        if (rType.getKeyType() != null) {
            return TypeConverter.convertMapType(rType);
        }
        return TypeConverter.convertPrimitiveType(rType);
    }

    public static TypeInfo convertStructType(RelDataType rType) {
        List fTypes = Lists.transform((List)rType.getFieldList(), (Function)new Function<RelDataTypeField, TypeInfo>(){

            public TypeInfo apply(RelDataTypeField f) {
                return TypeConverter.convert(f.getType());
            }
        });
        List fNames = Lists.transform((List)rType.getFieldList(), (Function)new Function<RelDataTypeField, String>(){

            public String apply(RelDataTypeField f) {
                return f.getName();
            }
        });
        boolean isUnionType = fNames.stream().allMatch(f -> f.startsWith(UNION_FIELD_PREFIX));
        if (isUnionType) {
            return TypeInfoFactory.getUnionTypeInfo((List)fTypes);
        }
        return TypeInfoFactory.getStructTypeInfo((List)fNames, (List)fTypes);
    }

    public static TypeInfo convertMapType(RelDataType rType) {
        return TypeInfoFactory.getMapTypeInfo((TypeInfo)TypeConverter.convert(rType.getKeyType()), (TypeInfo)TypeConverter.convert(rType.getValueType()));
    }

    public static TypeInfo convertListType(RelDataType rType) {
        return TypeInfoFactory.getListTypeInfo((TypeInfo)TypeConverter.convert(rType.getComponentType()));
    }

    public static TypeInfo convertPrimitiveType(RelDataType rType) {
        switch (rType.getSqlTypeName()) {
            case BOOLEAN: {
                return TypeInfoFactory.booleanTypeInfo;
            }
            case TINYINT: {
                return TypeInfoFactory.byteTypeInfo;
            }
            case SMALLINT: {
                return TypeInfoFactory.shortTypeInfo;
            }
            case INTEGER: {
                return TypeInfoFactory.intTypeInfo;
            }
            case BIGINT: {
                return TypeInfoFactory.longTypeInfo;
            }
            case FLOAT: {
                return TypeInfoFactory.floatTypeInfo;
            }
            case DOUBLE: {
                return TypeInfoFactory.doubleTypeInfo;
            }
            case DATE: {
                return TypeInfoFactory.dateTypeInfo;
            }
            case TIMESTAMP: {
                return TypeInfoFactory.timestampTypeInfo;
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                HiveConf conf;
                try {
                    conf = Hive.get().getConf();
                }
                catch (HiveException e) {
                    throw new RuntimeException(e);
                }
                return TypeInfoFactory.getTimestampTZTypeInfo((ZoneId)conf.getLocalTimeZone());
            }
            case INTERVAL_YEAR: 
            case INTERVAL_MONTH: 
            case INTERVAL_YEAR_MONTH: {
                return TypeInfoFactory.intervalYearMonthTypeInfo;
            }
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                return TypeInfoFactory.intervalDayTimeTypeInfo;
            }
            case BINARY: {
                return TypeInfoFactory.binaryTypeInfo;
            }
            case DECIMAL: {
                return TypeInfoFactory.getDecimalTypeInfo((int)rType.getPrecision(), (int)rType.getScale());
            }
            case VARCHAR: {
                int varcharLength = rType.getPrecision();
                if (varcharLength < 1 || varcharLength > 65535) {
                    return TypeInfoFactory.getPrimitiveTypeInfo((String)"string");
                }
                return TypeInfoFactory.getVarcharTypeInfo((int)varcharLength);
            }
            case CHAR: {
                int charLength = rType.getPrecision();
                if (charLength < 1 || charLength > 255) {
                    return TypeInfoFactory.getPrimitiveTypeInfo((String)"string");
                }
                return TypeInfoFactory.getCharTypeInfo((int)charLength);
            }
        }
        return TypeInfoFactory.voidTypeInfo;
    }

    public static SqlFunctionConverter.HiveToken hiveToken(RelDataType calciteType) {
        SqlFunctionConverter.HiveToken ht = null;
        switch (calciteType.getSqlTypeName()) {
            case CHAR: {
                ht = new SqlFunctionConverter.HiveToken(943, "TOK_CHAR", String.valueOf(calciteType.getPrecision()));
                break;
            }
            case VARCHAR: {
                if (calciteType.getPrecision() == Integer.MAX_VALUE) {
                    ht = new SqlFunctionConverter.HiveToken(1239, "TOK_STRING", String.valueOf(calciteType.getPrecision()));
                    break;
                }
                ht = new SqlFunctionConverter.HiveToken(1317, "TOK_VARCHAR", String.valueOf(calciteType.getPrecision()));
                break;
            }
            case DECIMAL: {
                ht = new SqlFunctionConverter.HiveToken(988, "TOK_DECIMAL", String.valueOf(calciteType.getPrecision()), String.valueOf(calciteType.getScale()));
                break;
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                ht = new SqlFunctionConverter.HiveToken(1288, "TOK_TIMESTAMPLOCALTZ", new String[0]);
                break;
            }
            default: {
                ht = calciteToHiveTypeNameMap.get(calciteType.getSqlTypeName().getName());
            }
        }
        return ht;
    }

    static {
        ImmutableMap.Builder b = ImmutableMap.builder();
        b.put((Object)SqlTypeName.BOOLEAN.getName(), (Object)new SqlFunctionConverter.HiveToken(937, "TOK_BOOLEAN", new String[0]));
        b.put((Object)SqlTypeName.TINYINT.getName(), (Object)new SqlFunctionConverter.HiveToken(1290, "TOK_TINYINT", new String[0]));
        b.put((Object)SqlTypeName.SMALLINT.getName(), (Object)new SqlFunctionConverter.HiveToken(1234, "TOK_SMALLINT", new String[0]));
        b.put((Object)SqlTypeName.INTEGER.getName(), (Object)new SqlFunctionConverter.HiveToken(1061, "TOK_INT", new String[0]));
        b.put((Object)SqlTypeName.BIGINT.getName(), (Object)new SqlFunctionConverter.HiveToken(934, "TOK_BIGINT", new String[0]));
        b.put((Object)SqlTypeName.FLOAT.getName(), (Object)new SqlFunctionConverter.HiveToken(1033, "TOK_FLOAT", new String[0]));
        b.put((Object)SqlTypeName.DOUBLE.getName(), (Object)new SqlFunctionConverter.HiveToken(1003, "TOK_DOUBLE", new String[0]));
        b.put((Object)SqlTypeName.DATE.getName(), (Object)new SqlFunctionConverter.HiveToken(981, "TOK_DATE", new String[0]));
        b.put((Object)SqlTypeName.TIMESTAMP.getName(), (Object)new SqlFunctionConverter.HiveToken(1286, "TOK_TIMESTAMP", new String[0]));
        b.put((Object)SqlTypeName.INTERVAL_YEAR.getName(), (Object)new SqlFunctionConverter.HiveToken(24, "interval_year_month", new String[0]));
        b.put((Object)SqlTypeName.INTERVAL_MONTH.getName(), (Object)new SqlFunctionConverter.HiveToken(24, "interval_year_month", new String[0]));
        b.put((Object)SqlTypeName.INTERVAL_YEAR_MONTH.getName(), (Object)new SqlFunctionConverter.HiveToken(24, "interval_year_month", new String[0]));
        b.put((Object)SqlTypeName.INTERVAL_DAY.getName(), (Object)new SqlFunctionConverter.HiveToken(24, "interval_day_time", new String[0]));
        b.put((Object)SqlTypeName.INTERVAL_DAY_HOUR.getName(), (Object)new SqlFunctionConverter.HiveToken(24, "interval_day_time", new String[0]));
        b.put((Object)SqlTypeName.INTERVAL_DAY_MINUTE.getName(), (Object)new SqlFunctionConverter.HiveToken(24, "interval_day_time", new String[0]));
        b.put((Object)SqlTypeName.INTERVAL_DAY_SECOND.getName(), (Object)new SqlFunctionConverter.HiveToken(24, "interval_day_time", new String[0]));
        b.put((Object)SqlTypeName.INTERVAL_HOUR.getName(), (Object)new SqlFunctionConverter.HiveToken(24, "interval_day_time", new String[0]));
        b.put((Object)SqlTypeName.INTERVAL_HOUR_MINUTE.getName(), (Object)new SqlFunctionConverter.HiveToken(24, "interval_day_time", new String[0]));
        b.put((Object)SqlTypeName.INTERVAL_HOUR_SECOND.getName(), (Object)new SqlFunctionConverter.HiveToken(24, "interval_day_time", new String[0]));
        b.put((Object)SqlTypeName.INTERVAL_MINUTE.getName(), (Object)new SqlFunctionConverter.HiveToken(24, "interval_day_time", new String[0]));
        b.put((Object)SqlTypeName.INTERVAL_MINUTE_SECOND.getName(), (Object)new SqlFunctionConverter.HiveToken(24, "interval_day_time", new String[0]));
        b.put((Object)SqlTypeName.INTERVAL_SECOND.getName(), (Object)new SqlFunctionConverter.HiveToken(24, "interval_day_time", new String[0]));
        b.put((Object)SqlTypeName.BINARY.getName(), (Object)new SqlFunctionConverter.HiveToken(935, "TOK_BINARY", new String[0]));
        calciteToHiveTypeNameMap = b.build();
    }
}

