/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules.views;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.util.ReflectUtil;
import org.apache.calcite.util.ReflectiveVisitor;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveAggregate;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveFilter;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveProject;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.IncrementalRebuildMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaterializedViewIncrementalRewritingRelVisitor
implements ReflectiveVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(MaterializedViewIncrementalRewritingRelVisitor.class);
    private final ReflectUtil.MethodDispatcher<Result> dispatcher = ReflectUtil.createMethodDispatcher(Result.class, (ReflectiveVisitor)this, (String)"visit", RelNode.class, (Class[])new Class[0]);

    public Result go(RelNode relNode) {
        Result result = (Result)this.dispatcher.invoke(new Object[]{relNode});
        if (result.containsAggregate) {
            return result;
        }
        if (result.incrementalRebuildMode == IncrementalRebuildMode.AVAILABLE) {
            return new Result(IncrementalRebuildMode.INSERT_ONLY);
        }
        return result;
    }

    public Result visit(RelNode relNode) {
        LOG.debug("Plan has unsupported operator {}", (Object)relNode);
        return new Result(IncrementalRebuildMode.NOT_AVAILABLE);
    }

    private Result visitChildOf(RelNode rel) {
        return this.visitChildOf(rel, 0);
    }

    private Result visitChildOf(RelNode rel, int index) {
        return (Result)this.dispatcher.invoke(new Object[]{rel.getInput(index)});
    }

    public Result visit(HiveTableScan scan) {
        RelOptHiveTable hiveTable = (RelOptHiveTable)scan.getTable();
        Table hiveTableMD = hiveTable.getHiveTableMD();
        if (hiveTableMD.getStorageHandler() != null) {
            if (hiveTableMD.getStorageHandler().areSnapshotsSupported()) {
                LOG.debug("Table scan of non-native table {} with {} storage handler supports insert only materialized view incremental rebuild.", (Object)hiveTableMD.getTableName(), (Object)hiveTableMD.getStorageHandler().getClass().getSimpleName());
                return new Result(IncrementalRebuildMode.INSERT_ONLY);
            }
            LOG.debug("Unsupported table type: non-native table {} with storage handler {}", (Object)hiveTableMD.getTableName(), (Object)hiveTableMD.getStorageHandler().getClass().getSimpleName());
            return new Result(IncrementalRebuildMode.NOT_AVAILABLE);
        }
        return new Result(IncrementalRebuildMode.AVAILABLE);
    }

    public Result visit(HiveProject project) {
        return this.visitChildOf(project);
    }

    public Result visit(HiveFilter filter) {
        return this.visitChildOf(filter);
    }

    public Result visit(HiveJoin join) {
        boolean containsAggregate;
        if (join.getJoinType() != JoinRelType.INNER) {
            LOG.debug("Unsupported join type {}", (Object)join.getJoinType());
            return new Result(IncrementalRebuildMode.NOT_AVAILABLE);
        }
        Result leftResult = this.visitChildOf(join, 0);
        Result rightResult = this.visitChildOf(join, 1);
        boolean bl = containsAggregate = leftResult.containsAggregate || rightResult.containsAggregate;
        if (leftResult.incrementalRebuildMode == IncrementalRebuildMode.NOT_AVAILABLE || rightResult.incrementalRebuildMode == IncrementalRebuildMode.NOT_AVAILABLE) {
            return new Result(IncrementalRebuildMode.NOT_AVAILABLE, containsAggregate);
        }
        if (leftResult.incrementalRebuildMode == IncrementalRebuildMode.INSERT_ONLY || rightResult.incrementalRebuildMode == IncrementalRebuildMode.INSERT_ONLY) {
            return new Result(IncrementalRebuildMode.INSERT_ONLY, containsAggregate);
        }
        return new Result(IncrementalRebuildMode.AVAILABLE, containsAggregate);
    }

    public Result visit(HiveAggregate aggregate) {
        Result result = this.visitChildOf(aggregate);
        if (result.incrementalRebuildMode == IncrementalRebuildMode.NOT_AVAILABLE) {
            return new Result(result.incrementalRebuildMode, true, -1);
        }
        HashMap<Integer, Set<SqlKind>> columnRefByAggregateCall = new HashMap<Integer, Set<SqlKind>>(aggregate.getRowType().getFieldCount());
        int countStarIndex = -1;
        for (int i = 0; i < aggregate.getAggCallList().size(); ++i) {
            AggregateCall aggregateCall = (AggregateCall)aggregate.getAggCallList().get(i);
            if (aggregateCall.getAggregation().getKind() == SqlKind.COUNT && aggregateCall.getArgList().isEmpty() && !aggregateCall.isDistinct() && !aggregateCall.isApproximate()) {
                countStarIndex = i;
                continue;
            }
            for (Integer argIndex : aggregateCall.getArgList()) {
                columnRefByAggregateCall.computeIfAbsent(argIndex, integer -> new HashSet());
                Set aggregates = (Set)columnRefByAggregateCall.get(argIndex);
                aggregates.add(aggregateCall.getAggregation().getKind());
            }
        }
        IncrementalRebuildMode incrementalRebuildMode = result.incrementalRebuildMode == IncrementalRebuildMode.INSERT_ONLY || countStarIndex == -1 ? IncrementalRebuildMode.INSERT_ONLY : IncrementalRebuildMode.AVAILABLE;
        LOG.debug("Initial incremental rebuild mode {} input's incremental rebuild mode {} count star index {}", new Object[]{incrementalRebuildMode, result.incrementalRebuildMode, countStarIndex});
        incrementalRebuildMode = this.updateBasedOnAggregates(aggregate, columnRefByAggregateCall, incrementalRebuildMode);
        return new Result(incrementalRebuildMode, true, countStarIndex);
    }

    private IncrementalRebuildMode updateBasedOnAggregates(HiveAggregate aggregate, Map<Integer, Set<SqlKind>> columnRefByAggregateCall, IncrementalRebuildMode incrementalRebuildMode) {
        block6: for (int i = 0; i < aggregate.getAggCallList().size(); ++i) {
            AggregateCall aggregateCall = (AggregateCall)aggregate.getAggCallList().get(i);
            switch (aggregateCall.getAggregation().getKind()) {
                case COUNT: {
                    if (aggregateCall.isDistinct() || aggregateCall.isApproximate()) {
                        LOG.debug("Unsupported aggregate function COUNT with distinct {} or approximate {}", (Object)aggregateCall.isDistinct(), (Object)aggregateCall.isApproximate());
                        return IncrementalRebuildMode.NOT_AVAILABLE;
                    }
                }
                case SUM: 
                case SUM0: {
                    continue block6;
                }
                case AVG: {
                    Set<SqlKind> aggregates = columnRefByAggregateCall.get(aggregateCall.getArgList().get(0));
                    if (aggregates.contains(SqlKind.SUM) && aggregates.contains(SqlKind.COUNT)) continue block6;
                    LOG.debug("Unsupported aggregate function AVG: missing SUM and COUNT of the same column.");
                    return IncrementalRebuildMode.NOT_AVAILABLE;
                }
                case MIN: 
                case MAX: {
                    incrementalRebuildMode = IncrementalRebuildMode.INSERT_ONLY;
                    LOG.debug("Found {} aggregate function. Incremental materialized view rebuild is supported in the presence of insert operations only", (Object)aggregateCall.getAggregation().getKind());
                    continue block6;
                }
                default: {
                    LOG.debug("Unsupported aggregate function {}.", (Object)aggregateCall.getAggregation().getKind());
                    return IncrementalRebuildMode.NOT_AVAILABLE;
                }
            }
        }
        return incrementalRebuildMode;
    }

    public static final class Result {
        private final IncrementalRebuildMode incrementalRebuildMode;
        private final boolean containsAggregate;
        private final int countStarIndex;

        private Result(IncrementalRebuildMode incrementalRebuildMode) {
            this(incrementalRebuildMode, false, -1);
        }

        private Result(IncrementalRebuildMode incrementalRebuildMode, boolean containsAggregate) {
            this(incrementalRebuildMode, containsAggregate, -1);
        }

        public Result(IncrementalRebuildMode incrementalRebuildMode, boolean containsAggregate, int countStarIndex) {
            this.incrementalRebuildMode = incrementalRebuildMode;
            this.containsAggregate = containsAggregate;
            this.countStarIndex = countStarIndex;
        }

        public IncrementalRebuildMode getIncrementalRebuildMode() {
            return this.incrementalRebuildMode;
        }

        public boolean containsAggregate() {
            return this.containsAggregate;
        }

        public int getCountStarIndex() {
            return this.countStarIndex;
        }

        public String toString() {
            return "Result{incrementalRebuildMode=" + String.valueOf((Object)this.incrementalRebuildMode) + ", containsAggregate=" + this.containsAggregate + ", countStarIndex=" + this.countStarIndex + "}";
        }
    }
}

