/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptMaterialization;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.prepare.RelOptTableImpl;
import org.apache.calcite.rel.core.Spool;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.CteRuleConfig;

public class TableScanToSpoolRule
extends RelRule<CteRuleConfig> {
    private final Set<String> spools = new HashSet<String>();

    public TableScanToSpoolRule(CteRuleConfig config) {
        super((RelRule.Config)config);
        if (config.referenceThreshold() <= 0) {
            throw new IllegalArgumentException("Invalid reference threshold:" + config.referenceThreshold());
        }
    }

    public boolean matches(RelOptRuleCall call) {
        TableScan scan = (TableScan)call.rel(0);
        List tableName = scan.getTable().getQualifiedName();
        if (this.spools.contains(tableName.toString())) {
            return false;
        }
        return ((CteRuleConfig)this.config).getTableOccurrences().getOrDefault(tableName, 0) > ((CteRuleConfig)this.config).referenceThreshold();
    }

    public void onMatch(RelOptRuleCall call) {
        TableScan scan = (TableScan)call.rel(0);
        String tableName = scan.getTable().getQualifiedName().toString();
        for (RelOptMaterialization cte : call.getPlanner().getMaterializations()) {
            if (!tableName.equals(cte.qualifiedTableName.toString()) || !this.spools.add(tableName)) continue;
            RelOptTableImpl cteTable = RelOptTableImpl.create(null, (RelDataType)scan.getRowType(), (List)scan.getTable().getQualifiedName(), null);
            call.transformTo(HiveRelFactories.HIVE_SPOOL_FACTORY.createTableSpool(cte.queryRel, Spool.Type.LAZY, Spool.Type.LAZY, (RelOptTable)cteTable));
        }
    }
}

