/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite;

import java.util.Objects;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.type.SqlTypeName;

public final class HiveSqlTypeUtil {
    private HiveSqlTypeUtil() {
        throw new IllegalStateException("Must not instantiate.");
    }

    public static boolean containsSqlType(RelDataType type, SqlTypeName typeName) {
        Objects.requireNonNull(typeName);
        if (type == null) {
            return false;
        }
        if (typeName.equals((Object)type.getSqlTypeName())) {
            return true;
        }
        if (type.isStruct()) {
            return type.getFieldList().stream().map(RelDataTypeField::getType).anyMatch(t -> HiveSqlTypeUtil.containsSqlType(t, typeName));
        }
        return HiveSqlTypeUtil.containsSqlType(type.getComponentType(), typeName) || HiveSqlTypeUtil.containsSqlType(type.getKeyType(), typeName) || HiveSqlTypeUtil.containsSqlType(type.getValueType(), typeName);
    }
}

