/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.lib;

import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.PreOrderWalker;
import org.apache.hadoop.hive.ql.lib.SemanticDispatcher;
import org.apache.hadoop.hive.ql.parse.SemanticException;

public class PreOrderOnceWalker
extends PreOrderWalker {
    private final Set<Class<? extends Node>> excludeNodes = new HashSet<Class<? extends Node>>();

    public PreOrderOnceWalker(SemanticDispatcher disp) {
        super(disp);
    }

    @Override
    public void walk(Node nd) throws SemanticException {
        if (this.excludeNodes.contains(nd.getClass())) {
            return;
        }
        this.opStack.push(nd);
        this.dispatch(nd, this.opStack);
        if (this.retMap.get(nd) != null) {
            this.opStack.pop();
            return;
        }
        if (nd.getChildren() != null) {
            for (Node n : nd.getChildren()) {
                this.walk(n);
            }
        }
        this.opStack.pop();
    }

    public void excludeNode(Class<? extends Node> type) {
        this.excludeNodes.add(type);
    }
}

