/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.protobuf;

import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.tez.dag.history.logging.proto.ProtoMessageWritable;

public class ProtobufMessageInputFormat<K, V extends MessageLite>
extends SequenceFileInputFormat<K, ProtoMessageWritable<V>> {
    private static final String PROTO_CLASS = "proto.class";

    private Parser<V> getParser(String protoClass) throws IOException {
        if (protoClass == null) {
            throw new IOException("Please specificy table property: proto.class");
        }
        try {
            Class<?> clazz = ((Object)((Object)this)).getClass().getClassLoader().loadClass(protoClass);
            return (Parser)clazz.getField("PARSER").get(null);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new IOException("Could not load class: " + protoClass, e);
        }
    }

    private RecordReader<K, ProtoMessageWritable<V>> getSafeRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        try {
            return super.getRecordReader(split, job, reporter);
        }
        catch (EOFException e) {
            return null;
        }
    }

    public RecordReader<K, ProtoMessageWritable<V>> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        final Parser<V> parser = this.getParser(job.get(PROTO_CLASS));
        final RecordReader<K, ProtoMessageWritable<V>> reader = this.getSafeRecordReader(split, job, reporter);
        return new RecordReader<K, ProtoMessageWritable<V>>(){

            public ProtoMessageWritable<V> createValue() {
                try {
                    Constructor cons = ProtoMessageWritable.class.getDeclaredConstructor(Parser.class);
                    cons.setAccessible(true);
                    return (ProtoMessageWritable)cons.newInstance(parser);
                }
                catch (Exception e) {
                    throw new RuntimeException("Unexpected error: ", e);
                }
            }

            public K createKey() {
                return reader != null ? reader.createKey() : null;
            }

            public void close() throws IOException {
                if (reader != null) {
                    reader.close();
                }
            }

            public long getPos() throws IOException {
                return reader != null ? reader.getPos() : 0L;
            }

            public float getProgress() throws IOException {
                return reader != null ? reader.getProgress() : 1.0f;
            }

            public boolean next(K arg0, ProtoMessageWritable<V> arg1) throws IOException {
                return reader != null ? reader.next(arg0, arg1) : false;
            }
        };
    }
}

