/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.AcidInputFormat;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.ColumnarSplit;
import org.apache.hadoop.hive.ql.io.LlapAwareSplit;
import org.apache.hadoop.hive.ql.io.SyntheticFileId;
import org.apache.hadoop.hive.ql.io.orc.OrcRawRecordMerger;
import org.apache.hadoop.hive.ql.io.orc.VectorizedOrcAcidRowBatchReader;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.orc.OrcProto;
import org.apache.orc.impl.OrcTail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrcSplit
extends FileSplit
implements ColumnarSplit,
LlapAwareSplit {
    private static final Logger LOG = LoggerFactory.getLogger(OrcSplit.class);
    private OrcTail orcTail;
    private boolean hasFooter;
    private boolean isOriginal;
    private boolean hasBase;
    private Path rootDir;
    private final List<AcidInputFormat.DeltaMetaData> deltas = new ArrayList<AcidInputFormat.DeltaMetaData>();
    private long projColsUncompressedSize;
    private transient Object fileKey;
    private long fileLen;
    private transient long writeId = 0L;
    private transient int bucketId = 0;
    private transient int stmtId = 0;
    private OffsetAndBucketProperty syntheticAcidProps;
    static final int HAS_SYNTHETIC_ACID_PROPS_FLAG = 32;
    static final int HAS_SYNTHETIC_FILEID_FLAG = 16;
    static final int HAS_LONG_FILEID_FLAG = 8;
    static final int BASE_FLAG = 4;
    static final int ORIGINAL_FLAG = 2;
    static final int FOOTER_FLAG = 1;

    protected OrcSplit() {
        super(null, 0L, 0L, (String[])null);
    }

    public OrcSplit(Path path, Object fileId, long offset, long length, String[] hosts, OrcTail orcTail, boolean isOriginal, boolean hasBase, List<AcidInputFormat.DeltaMetaData> deltas, long projectedDataSize, long fileLen, Path rootDir, OffsetAndBucketProperty syntheticAcidProps) {
        super(path, offset, length, hosts);
        this.fileKey = fileId;
        this.orcTail = orcTail;
        this.hasFooter = this.orcTail != null;
        this.isOriginal = isOriginal;
        this.hasBase = hasBase;
        this.rootDir = rootDir;
        int bucketId = AcidUtils.parseBucketId(path);
        long minWriteId = !deltas.isEmpty() ? AcidUtils.parseBaseOrDeltaBucketFilename(path, null).getMinimumWriteId() : -1L;
        this.deltas.addAll(deltas.stream().filter(delta -> delta.getMaxWriteId() >= minWriteId).flatMap(delta -> this.filterDeltasByBucketId((AcidInputFormat.DeltaMetaData)delta, bucketId)).collect(Collectors.toList()));
        this.projColsUncompressedSize = projectedDataSize <= 0L ? length : projectedDataSize;
        this.fileLen = fileLen <= 0L ? Long.MAX_VALUE : fileLen;
        this.syntheticAcidProps = syntheticAcidProps;
    }

    private Stream<AcidInputFormat.DeltaMetaData> filterDeltasByBucketId(AcidInputFormat.DeltaMetaData dmd, int bucketId) {
        Map bucketFilesbyStmtId = dmd.getDeltaFiles().stream().filter(deltaFileMetaData -> deltaFileMetaData.getBucketId() == bucketId).collect(Collectors.toMap(AcidInputFormat.DeltaFileMetaData::getStmtId, Function.identity()));
        if (bucketFilesbyStmtId.isEmpty()) {
            return Stream.empty();
        }
        List<Integer> stmtIds = dmd.getStmtIds().stream().filter(stmtId -> bucketFilesbyStmtId.containsKey(stmtId)).collect(Collectors.toList());
        List<AcidInputFormat.DeltaFileMetaData> bucketFiles = bucketFilesbyStmtId.values().stream().map(file -> new AcidInputFormat.DeltaFileMetaData(file.getModTime(), file.getLength(), file.getAttemptId(), file.getFileId(), stmtIds.size() > 1 ? file.getStmtId() : null, bucketId)).collect(Collectors.toList());
        return Stream.of(new AcidInputFormat.DeltaMetaData(dmd.getMinWriteId(), dmd.getMaxWriteId(), stmtIds, dmd.getVisibilityTxnId(), bucketFiles));
    }

    public void write(DataOutput out) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        super.write((DataOutput)dos);
        int required = bos.size();
        this.writeAdditionalPayload(dos);
        int additional = bos.size() - required;
        out.write(bos.toByteArray());
        if (LOG.isTraceEnabled()) {
            LOG.trace("Writing additional {} bytes to OrcSplit as payload. Required {} bytes.", (Object)additional, (Object)required);
        }
    }

    private void writeAdditionalPayload(DataOutputStream out) throws IOException {
        boolean isFileIdLong = this.fileKey instanceof Long;
        boolean isFileIdWritable = this.fileKey instanceof Writable;
        int flags = (this.hasBase ? 4 : 0) | (this.isOriginal ? 2 : 0) | (this.hasFooter ? 1 : 0) | (isFileIdLong ? 8 : 0) | (isFileIdWritable ? 16 : 0) | (this.syntheticAcidProps != null ? 32 : 0);
        out.writeByte(flags);
        out.writeInt(this.deltas.size());
        for (AcidInputFormat.DeltaMetaData delta : this.deltas) {
            delta.write(out);
        }
        if (this.hasFooter) {
            OrcProto.FileTail fileTail = this.orcTail.getMinimalFileTail();
            byte[] tailBuffer = fileTail.toByteArray();
            int tailLen = tailBuffer.length;
            WritableUtils.writeVInt((DataOutput)out, (int)tailLen);
            out.write(tailBuffer);
        }
        if (isFileIdLong) {
            out.writeLong((Long)this.fileKey);
        } else if (isFileIdWritable) {
            ((Writable)this.fileKey).write((DataOutput)out);
        }
        out.writeLong(this.fileLen);
        out.writeUTF(this.rootDir.toString());
        if (this.syntheticAcidProps != null) {
            out.writeLong(this.syntheticAcidProps.rowIdOffset);
            out.writeInt(this.syntheticAcidProps.bucketProperty);
            out.writeLong(this.syntheticAcidProps.syntheticWriteId);
        }
    }

    public void readFields(DataInput in) throws IOException {
        boolean hasSyntheticProps;
        super.readFields(in);
        byte flags = in.readByte();
        this.hasFooter = (1 & flags) != 0;
        this.isOriginal = (2 & flags) != 0;
        this.hasBase = (4 & flags) != 0;
        boolean hasLongFileId = (8 & flags) != 0;
        boolean hasWritableFileId = (0x10 & flags) != 0;
        boolean bl = hasSyntheticProps = (0x20 & flags) != 0;
        if (hasLongFileId && hasWritableFileId) {
            throw new IOException("Invalid split - both file ID types present");
        }
        this.deltas.clear();
        int numDeltas = in.readInt();
        for (int i = 0; i < numDeltas; ++i) {
            AcidInputFormat.DeltaMetaData dmd = new AcidInputFormat.DeltaMetaData();
            dmd.readFields(in);
            this.deltas.add(dmd);
        }
        if (this.hasFooter) {
            int tailLen = WritableUtils.readVInt((DataInput)in);
            byte[] tailBuffer = new byte[tailLen];
            in.readFully(tailBuffer);
            OrcProto.FileTail fileTail = OrcProto.FileTail.parseFrom((byte[])tailBuffer);
            this.orcTail = new OrcTail(fileTail, null);
        }
        if (hasLongFileId) {
            this.fileKey = in.readLong();
        } else if (hasWritableFileId) {
            SyntheticFileId fileId = new SyntheticFileId();
            fileId.readFields(in);
            this.fileKey = fileId;
        }
        this.fileLen = in.readLong();
        this.rootDir = new Path(in.readUTF());
        if (hasSyntheticProps) {
            long rowId = in.readLong();
            int bucket = in.readInt();
            long writeId = in.readLong();
            this.syntheticAcidProps = new OffsetAndBucketProperty(rowId, bucket, writeId);
        }
    }

    public OrcTail getOrcTail() {
        return this.orcTail;
    }

    public boolean hasFooter() {
        return this.hasFooter;
    }

    public boolean isOriginal() {
        return this.isOriginal;
    }

    public boolean hasBase() {
        return this.hasBase;
    }

    public Path getRootDir() {
        return this.rootDir;
    }

    public List<AcidInputFormat.DeltaMetaData> getDeltas() {
        return this.deltas;
    }

    public long getFileLength() {
        return this.fileLen;
    }

    public boolean isAcid() {
        return this.hasBase || this.deltas.size() > 0;
    }

    public long getProjectedColumnsUncompressedSize() {
        return this.projColsUncompressedSize;
    }

    public Object getFileKey() {
        return this.fileKey;
    }

    public OffsetAndBucketProperty getSyntheticAcidProps() {
        return this.syntheticAcidProps;
    }

    @Override
    public long getColumnarProjectionSize() {
        return this.projColsUncompressedSize;
    }

    @Override
    public boolean canUseLlapIo(Configuration conf) {
        if (AcidUtils.isFullAcidScan(conf)) {
            if (HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_ACID_ENABLED) && Utilities.getIsVectorized(conf)) {
                boolean hasDeleteDelta = this.deltas != null && !this.deltas.isEmpty();
                return VectorizedOrcAcidRowBatchReader.canUseLlapIoForAcid(this, hasDeleteDelta, conf);
            }
            LOG.info("Skipping Llap IO based on the following: [vectorized={}, hive.llap.io.acid={}] for {}", new Object[]{Utilities.getIsVectorized(conf), HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_ACID_ENABLED), this});
            return false;
        }
        return true;
    }

    public long getWriteId() {
        return this.writeId;
    }

    public int getStatementId() {
        return this.stmtId;
    }

    public int getBucketId() {
        return this.bucketId;
    }

    public void parse(Configuration conf) throws IOException {
        this.parse(conf, this.rootDir);
    }

    public void parse(Configuration conf, Path rootPath) throws IOException {
        OrcRawRecordMerger.TransactionMetaData tmd = OrcRawRecordMerger.TransactionMetaData.findWriteIDForSynthetcRowIDs(this.getPath(), rootPath, conf);
        this.writeId = tmd.syntheticWriteId;
        this.stmtId = tmd.statementId;
        this.bucketId = AcidUtils.parseBucketId(this.getPath());
    }

    public String toString() {
        return "OrcSplit [" + String.valueOf(this.getPath()) + ", start=" + this.getStart() + ", length=" + this.getLength() + ", isOriginal=" + this.isOriginal + ", fileLength=" + this.fileLen + ", hasFooter=" + this.hasFooter + ", hasBase=" + this.hasBase + ", deltas=" + (this.deltas == null ? 0 : this.deltas.size()) + "]";
    }

    public static final class OffsetAndBucketProperty {
        private final long rowIdOffset;
        private final int bucketProperty;
        private final long syntheticWriteId;

        OffsetAndBucketProperty(long rowIdOffset, int bucketProperty, long syntheticWriteId) {
            this.rowIdOffset = rowIdOffset;
            this.bucketProperty = bucketProperty;
            this.syntheticWriteId = syntheticWriteId;
        }

        public long getRowIdOffset() {
            return this.rowIdOffset;
        }

        public int getBucketProperty() {
            return this.bucketProperty;
        }

        public long getSyntheticWriteId() {
            return this.syntheticWriteId;
        }
    }
}

