/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.NullRowsInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TextInputFormat;

public class SkippingTextInputFormat
extends TextInputFormat {
    private final Map<Path, Long> startIndexMap = new ConcurrentHashMap<Path, Long>();
    private final Map<Path, Long> endIndexMap = new ConcurrentHashMap<Path, Long>();
    private JobConf conf;
    private int headerCount;
    private int footerCount;

    public void configure(JobConf conf) {
        this.conf = conf;
        super.configure(conf);
    }

    public void configure(JobConf conf, int headerCount, int footerCount) {
        this.configure(conf);
        this.headerCount = headerCount;
        this.footerCount = footerCount;
    }

    protected FileSplit makeSplit(Path file, long start, long length, String[] hosts) {
        return this.makeSplitInternal(file, start, length, hosts, null);
    }

    protected FileSplit makeSplit(Path file, long start, long length, String[] hosts, String[] inMemoryHosts) {
        return this.makeSplitInternal(file, start, length, hosts, inMemoryHosts);
    }

    private FileSplit makeSplitInternal(Path file, long start, long length, String[] hosts, String[] inMemoryHosts) {
        long cachedEnd;
        long cachedStart;
        try {
            cachedStart = this.getCachedStartIndex(file);
            cachedEnd = this.getCachedEndIndex(file);
        }
        catch (IOException e) {
            LOG.warn("Could not detect header/footer", (Throwable)e);
            return new NullRowsInputFormat.DummyInputSplit(file);
        }
        if (cachedStart > start + length) {
            return new NullRowsInputFormat.DummyInputSplit(file);
        }
        if (cachedStart > start) {
            length -= cachedStart - start;
            start = cachedStart;
        }
        if (cachedEnd < start) {
            return new NullRowsInputFormat.DummyInputSplit(file);
        }
        if (cachedEnd < start + length) {
            length = cachedEnd - start;
        }
        if (inMemoryHosts == null) {
            return super.makeSplit(file, start, length, hosts);
        }
        return super.makeSplit(file, start, length, hosts, inMemoryHosts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getCachedStartIndex(Path path) throws IOException {
        if (this.headerCount == 0) {
            return 0L;
        }
        Long startIndexForFile = this.startIndexMap.get(path);
        if (startIndexForFile == null) {
            FileSystem fileSystem = path.getFileSystem((Configuration)this.conf);
            try (FSDataInputStream fis = null;){
                fis = fileSystem.open(path);
                long currPos = fis.getPos();
                int delimiterIdx = -1;
                for (int j = 0; j < this.headerCount; ++j) {
                    String headerLine = fis.readLine();
                    if (headerLine == null) {
                        this.startIndexMap.put(path, Long.MAX_VALUE);
                        long l = Long.MAX_VALUE;
                        return l;
                    }
                    if (j == this.headerCount - 1) {
                        String delimiter = this.conf.get("textinputformat.record.delimiter");
                        if (delimiter != null && !delimiter.isEmpty()) {
                            delimiterIdx = headerLine.indexOf(delimiter);
                            continue;
                        }
                        currPos = fis.getPos();
                        continue;
                    }
                    currPos = fis.getPos();
                }
                startIndexForFile = currPos + (long)delimiterIdx;
            }
            this.startIndexMap.put(path, startIndexForFile);
        }
        return startIndexForFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getCachedEndIndex(Path path) throws IOException {
        Long endIndexForFile = this.endIndexMap.get(path);
        if (endIndexForFile == null) {
            long bufferSectionSize = 5120L;
            FileSystem fileSystem = path.getFileSystem((Configuration)this.conf);
            long endOfFile = fileSystem.getFileStatus(path).getLen();
            if (this.footerCount == 0) {
                endIndexForFile = endOfFile;
            } else {
                long bufferSectionEnd = endOfFile;
                long bufferSectionStart = Math.max(0L, bufferSectionEnd - 5120L);
                LineBuffer buffer = new LineBuffer(this.footerCount + 1);
                try (FSDataInputStream fis = null;){
                    fis = fileSystem.open(path);
                    while (bufferSectionEnd > bufferSectionStart) {
                        fis.seek(bufferSectionStart);
                        long pos = fis.getPos();
                        while (pos < bufferSectionEnd && fis.readLine() != null) {
                            pos = fis.getPos();
                            buffer.consume(pos, bufferSectionEnd);
                        }
                        if (buffer.getRemainingLineCount() == 0) break;
                        bufferSectionEnd = bufferSectionStart;
                        bufferSectionStart = Math.max(0L, bufferSectionEnd - 5120L);
                    }
                    endIndexForFile = buffer.getRemainingLineCount() == 0 ? Long.valueOf(buffer.getFirstLineStart() - 1L) : Long.valueOf(Long.MIN_VALUE);
                }
            }
            this.endIndexMap.put(path, endIndexForFile);
        }
        return endIndexForFile;
    }

    static class LineBuffer {
        private final Queue<Long> queue = new ArrayDeque<Long>();
        private int remainingLineEnds;
        private long lowPosition = Long.MAX_VALUE;

        LineBuffer(int requiredLines) {
            this.remainingLineEnds = requiredLines;
        }

        public void consume(long position, long sectionEnd) {
            if (position > sectionEnd) {
                return;
            }
            if (position < this.lowPosition) {
                this.remainingLineEnds -= this.queue.size();
                this.queue.clear();
                this.queue.add(position);
                this.lowPosition = position;
            } else if (position > this.lowPosition) {
                if (this.queue.size() == this.remainingLineEnds) {
                    this.queue.poll();
                }
                this.queue.add(position);
                this.lowPosition = this.queue.peek();
            }
        }

        public int getRemainingLineCount() {
            return this.remainingLineEnds - this.queue.size();
        }

        public long getFirstLineStart() {
            return this.lowPosition;
        }
    }
}

