/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import com.google.common.base.Preconditions;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;

public enum BucketCodec {
    V0(0){

        @Override
        public int decodeWriterId(int bucketProperty) {
            return bucketProperty;
        }

        @Override
        public int decodeStatementId(int bucketProperty) {
            return 0;
        }

        @Override
        public int encode(AcidOutputFormat.Options options) {
            return options.getBucketId();
        }
    }
    ,
    V1(1){

        @Override
        public int decodeWriterId(int bucketProperty) {
            return (bucketProperty & 0xFFF0000) >>> 16;
        }

        @Override
        public int decodeStatementId(int bucketProperty) {
            return bucketProperty & 0xFFF;
        }

        @Override
        public int encode(AcidOutputFormat.Options options) {
            int statementId = Math.max(0, options.getStatementId());
            int bucketId = options.getBucketId();
            int maxStatementId = options.getMaxStmtId();
            if (maxStatementId < 0) {
                maxStatementId = 4095;
            } else if (maxStatementId == 0) {
                maxStatementId = 1;
            }
            Preconditions.checkArgument((maxStatementId >= 0 && maxStatementId <= 4095 ? 1 : 0) != 0, (Object)("Max Statement ID out of range: " + bucketId));
            Preconditions.checkArgument((statementId >= 0 && statementId <= 4095 ? 1 : 0) != 0, (Object)("Statement ID out of range: " + statementId));
            Preconditions.checkArgument((bucketId >= 0 ? 1 : 0) != 0, (Object)("Bucket ID out of range: " + bucketId));
            if (bucketId > 4095) {
                int extraBits = 12 - (32 - Integer.numberOfLeadingZeros(maxStatementId));
                int overflowedParts = bucketId >>> 12;
                int maxBucketId = (1 << 12 + extraBits) - 1;
                Preconditions.checkArgument((bucketId >= 0 && bucketId <= maxBucketId ? 1 : 0) != 0, (Object)("Bucket ID out of range: " + bucketId + " max: " + maxBucketId));
                statementId = overflowedParts << 12 - extraBits | statementId;
                bucketId &= 0xFFF;
            }
            return this.version << 29 | bucketId << 16 | Math.max(0, statementId);
        }
    };

    private static final int TOP3BITS_MASK = -536870912;
    private static final int NUM_VERSION_BITS = 3;
    private static final int NUM_BUCKET_ID_BITS = 12;
    private static final int NUM_STATEMENT_ID_BITS = 12;
    public static final int MAX_VERSION = 7;
    public static final int MAX_BUCKET_ID = 4095;
    public static final int MAX_STATEMENT_ID = 4095;
    final int version;

    public static BucketCodec determineVersion(int bucket) {
        try {
            return BucketCodec.getCodec((0xE0000000 & bucket) >>> 29);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("Cannot decode version from bucket number: " + Integer.toHexString(bucket), iae);
        }
    }

    public static BucketCodec getCodec(int version) {
        switch (version) {
            case 0: {
                return V0;
            }
            case 1: {
                return V1;
            }
        }
        throw new IllegalArgumentException("Illegal 'bucket' format. Version=" + version);
    }

    private BucketCodec(int version) {
        Preconditions.checkPositionIndex((int)version, (int)7, (String)("Version out of range: " + version));
        this.version = version;
    }

    public abstract int decodeWriterId(int var1);

    public abstract int decodeStatementId(int var1);

    public abstract int encode(AcidOutputFormat.Options var1);

    public int getVersion() {
        return this.version;
    }
}

