/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hive.common.util.Ref;

public final class AcidDirectory
implements AcidUtils.Directory {
    private final Path path;
    private final FileSystem fs;
    private final Ref<Boolean> useFileId;
    private AcidUtils.ParsedBase base;
    private AcidUtils.ParsedBaseLight oldestBase;
    private final List<Path> abortedDirectories = new ArrayList<Path>();
    private final Set<Long> abortedWriteIds = new HashSet<Long>();
    private boolean unCompactedAborts;
    private final List<HadoopShims.HdfsFileStatusWithId> originalFiles = new ArrayList<HadoopShims.HdfsFileStatusWithId>();
    private final List<Path> originalDirectories = new ArrayList<Path>();
    private final List<Path> obsolete = new ArrayList<Path>();
    private final List<AcidUtils.ParsedDelta> currentDirectories = new ArrayList<AcidUtils.ParsedDelta>();

    public AcidDirectory(Path path, FileSystem fs, Ref<Boolean> useFileId) {
        this.path = path;
        this.fs = fs;
        this.useFileId = useFileId;
        if (!(this.fs instanceof DistributedFileSystem) && this.useFileId != null) {
            this.useFileId.value = false;
        }
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    public Path getBaseDirectory() {
        return this.base == null ? null : this.base.getBaseDirPath();
    }

    public AcidUtils.ParsedBase getBase() {
        return this.base;
    }

    public AcidUtils.ParsedBaseLight getOldestBase() {
        return this.oldestBase;
    }

    public void setBase(AcidUtils.ParsedBase base) {
        this.base = base;
    }

    public void setOldestBase(AcidUtils.ParsedBaseLight oldestBase) {
        this.oldestBase = oldestBase;
    }

    public void setUnCompactedAborts(boolean unCompactedAborts) {
        this.unCompactedAborts = unCompactedAborts;
    }

    public boolean isBaseInRawFormat() {
        return this.base != null && this.base.isRawFormat();
    }

    public List<HadoopShims.HdfsFileStatusWithId> getOriginalFiles() {
        return this.originalFiles;
    }

    public List<Path> getOriginalDirectories() {
        return this.originalDirectories;
    }

    public List<AcidUtils.ParsedDelta> getCurrentDirectories() {
        return this.currentDirectories;
    }

    public List<Path> getObsolete() {
        return this.obsolete;
    }

    public List<Path> getAbortedDirectories() {
        return this.abortedDirectories;
    }

    public Set<Long> getAbortedWriteIds() {
        return this.abortedWriteIds;
    }

    public boolean hasUncompactedAborts() {
        return this.unCompactedAborts;
    }

    @Override
    public FileSystem getFs() {
        return this.fs;
    }

    @Override
    public List<AcidUtils.ParsedDelta> getDeleteDeltas() {
        return this.currentDirectories.stream().filter(AcidUtils.ParsedDeltaLight::isDeleteDelta).collect(Collectors.toList());
    }

    @Override
    public List<AcidUtils.FileInfo> getFiles() throws IOException {
        ArrayList<AcidUtils.FileInfo> baseAndDeltaFiles = new ArrayList<AcidUtils.FileInfo>();
        if (this.base == null) {
            for (HadoopShims.HdfsFileStatusWithId fileId : this.originalFiles) {
                baseAndDeltaFiles.add(new AcidUtils.FileInfo(fileId, AcidUtils.AcidBaseFileType.ORIGINAL_BASE));
            }
        } else {
            for (HadoopShims.HdfsFileStatusWithId fileId : this.base.getFiles(this.fs, this.useFileId)) {
                baseAndDeltaFiles.add(new AcidUtils.FileInfo(fileId, this.isBaseInRawFormat() ? AcidUtils.AcidBaseFileType.ORIGINAL_BASE : AcidUtils.AcidBaseFileType.ACID_SCHEMA));
            }
        }
        for (AcidUtils.ParsedDelta parsedDelta : this.currentDirectories) {
            if (parsedDelta.isDeleteDelta()) continue;
            if (parsedDelta.isRawFormat() && parsedDelta.getMinWriteId() != parsedDelta.getMaxWriteId()) {
                throw new IllegalStateException("Delta in " + String.valueOf((Object)AcidUtils.AcidBaseFileType.ORIGINAL_BASE) + " format but txnIds are out of range: " + String.valueOf(parsedDelta.getPath()));
            }
            AcidUtils.AcidBaseFileType deltaType = parsedDelta.isRawFormat() ? AcidUtils.AcidBaseFileType.ORIGINAL_BASE : AcidUtils.AcidBaseFileType.ACID_SCHEMA;
            for (HadoopShims.HdfsFileStatusWithId deltaFile : parsedDelta.getFiles(this.fs, this.useFileId)) {
                baseAndDeltaFiles.add(new AcidUtils.FileInfo(deltaFile, deltaType));
            }
        }
        return baseAndDeltaFiles;
    }

    public String toString() {
        return "Aborted Directories: " + String.valueOf(this.abortedDirectories) + "; aborted writeIds: " + String.valueOf(this.abortedWriteIds) + "; original: " + String.valueOf(this.originalFiles) + "; obsolete: " + String.valueOf(this.obsolete) + "; currentDirectories: " + String.valueOf(this.currentDirectories) + "; base: " + String.valueOf(this.base);
    }
}

