/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.hooks;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.database.alter.poperties.AlterDatabaseSetPropertiesDesc;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.hooks.ExecuteWithHookContext;
import org.apache.hadoop.hive.ql.hooks.HookContext;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnforceReadOnlyDatabaseHook
implements ExecuteWithHookContext {
    public static final String READONLY = "readonly";
    private static final Logger LOG = LoggerFactory.getLogger(EnforceReadOnlyDatabaseHook.class);

    @Override
    public void run(HookContext hookContext) throws Exception {
        assert (hookContext.getHookType() == HookContext.HookType.PRE_EXEC_HOOK);
        QueryState queryState = hookContext.getQueryState();
        HiveOperation hiveOperation = queryState.getHiveOperation();
        if (EnforceReadOnlyDatabaseHook.isReadOnlyOperation(hiveOperation)) {
            return;
        }
        if (EnforceReadOnlyDatabaseHook.isExplainOrSelectQuery(hookContext)) {
            return;
        }
        if (EnforceReadOnlyDatabaseHook.isAlterDbWritable(hookContext)) {
            return;
        }
        if (hiveOperation == HiveOperation.REPLLOAD) {
            return;
        }
        EnforceReadOnlyDatabaseHook.checkReadOnlyDbAsOutput(hookContext);
    }

    private static void checkReadOnlyDbAsOutput(HookContext hookContext) throws HiveException {
        LOG.debug(hookContext.getQueryPlan().getOutputs().toString());
        Set<WriteEntity> outputs = hookContext.getQueryPlan().getOutputs();
        for (WriteEntity output : outputs) {
            Database database;
            Hive hive = SessionState.get().getHiveDb();
            if (output.getDatabase() == null) {
                database = hive.getDatabase(output.getTable().getDbName());
            } else {
                database = output.getDatabase();
                boolean exists = hive.databaseExists(database.getName());
                LOG.debug("database exists: {}", (Object)exists);
                if (!exists) continue;
            }
            Map parameters = database.getParameters();
            LOG.debug("database name: " + database.getName() + " param: " + String.valueOf(database.getParameters()));
            if (parameters == null || parameters.isEmpty() || !parameters.containsKey(READONLY) || !"true".equalsIgnoreCase((String)parameters.get(READONLY))) continue;
            throw new SemanticException(ErrorMsg.READ_ONLY_DATABASE, new String[]{database.getName()});
        }
    }

    private static boolean isExplainOrSelectQuery(HookContext hookContext) {
        QueryState queryState = hookContext.getQueryState();
        HiveOperation hiveOperation = queryState.getHiveOperation();
        if (hiveOperation == HiveOperation.QUERY) {
            if (hookContext.getQueryPlan().isExplain()) {
                return true;
            }
            String upper = queryState.getQueryString().trim().toUpperCase();
            if (upper.startsWith("SELECT")) {
                return true;
            }
        }
        return false;
    }

    private static boolean isAlterDbWritable(HookContext hookContext) {
        DDLWork ddlWork;
        DDLDesc ddlDesc;
        Object rootWork;
        List<Task<?>> rootTasks;
        HiveOperation hiveOperation = hookContext.getQueryState().getHiveOperation();
        if (hiveOperation == HiveOperation.ALTERDATABASE && (rootTasks = hookContext.getQueryPlan().getRootTasks()).size() == 1 && (rootWork = rootTasks.get(0).getWork()) instanceof DDLWork && (ddlDesc = (ddlWork = (DDLWork)rootWork).getDDLDesc()) instanceof AlterDatabaseSetPropertiesDesc) {
            AlterDatabaseSetPropertiesDesc alterDatabaseDesc = (AlterDatabaseSetPropertiesDesc)ddlDesc;
            Map<String, String> properties = alterDatabaseDesc.getDatabaseProperties();
            if (properties == null) {
                return true;
            }
            if (!properties.containsKey(READONLY)) {
                return true;
            }
            if (!"true".equalsIgnoreCase(properties.get(READONLY))) {
                return true;
            }
        }
        return false;
    }

    private static boolean isReadOnlyOperation(HiveOperation hiveOperation) {
        switch (hiveOperation) {
            case EXPLAIN: 
            case SWITCHDATABASE: 
            case REPLDUMP: 
            case REPLSTATUS: 
            case EXPORT: 
            case KILL_QUERY: {
                return true;
            }
        }
        return Sets.newHashSet((Object[])new String[]{"SHOW", "DESC"}).stream().anyMatch(hiveOperation.name()::startsWith);
    }
}

