/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.ptf;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.hadoop.hive.ql.exec.vector.VectorDeserializeRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorSerializeRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.ptf.BufferedVectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.rowbytescontainer.VectorRowBytesContainer;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.lazybinary.fast.LazyBinaryDeserializeRead;
import org.apache.hadoop.hive.serde2.lazybinary.fast.LazyBinarySerializeWrite;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class VectorSpillBlockContainer {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private final List<VectorSpillBlock> blocks = new ArrayList<VectorSpillBlock>();
    private final int blockSize;
    private final String spillLocalDirs;
    private final int[] bufferedColumnMap;
    private final TypeInfo[] bufferedTypeInfos;
    private int startBatchIndexInMemory = 0;

    public VectorSpillBlockContainer(int blockSize, String spillLocalDirs, int[] bufferedColumnMap, TypeInfo[] bufferedTypeInfos) {
        this.blockSize = blockSize;
        this.spillLocalDirs = spillLocalDirs;
        this.bufferedColumnMap = bufferedColumnMap;
        this.bufferedTypeInfos = bufferedTypeInfos;
    }

    int size() {
        return this.blocks.size();
    }

    boolean isEmpty() {
        return this.blocks.isEmpty();
    }

    VectorSpillBlock get(int i) {
        return this.blocks.get(i);
    }

    boolean add(VectorSpillBlock block) {
        return this.blocks.add(block);
    }

    void clear() {
        for (VectorSpillBlock block : this.blocks) {
            block.cleanup();
        }
        this.blocks.clear();
        this.startBatchIndexInMemory = 0;
    }

    int getRowSize(int countBufferedRows) {
        int count = 0;
        boolean countedInMemoryBlock = false;
        for (VectorSpillBlock block : this.blocks) {
            if (block.startBatchIndex == this.startBatchIndexInMemory) {
                count += countBufferedRows;
                countedInMemoryBlock = true;
                continue;
            }
            count = (int)((long)count + block.spillRowCount);
        }
        if (!countedInMemoryBlock) {
            count += countBufferedRows;
        }
        return count;
    }

    void updateStartBatchIndexInMemory() {
        this.startBatchIndexInMemory = this.blocks.get((int)(this.blocks.size() - 1)).startBatchIndex + this.blockSize;
    }

    boolean isBlockInMemory(VectorSpillBlock block) {
        return block.startBatchIndex == this.startBatchIndexInMemory;
    }

    int getStartBatchIndexInMemory() {
        return this.startBatchIndexInMemory;
    }

    void setStartBatchIndexInMemory(int startBatchIndexInMemory) {
        this.startBatchIndexInMemory = startBatchIndexInMemory;
    }

    void setStartBatchIndexInMemory(VectorSpillBlock block) {
        this.startBatchIndexInMemory = block.startBatchIndex;
    }

    VectorSpillBlock getLast() {
        return this.blocks.get(this.blocks.size() - 1);
    }

    boolean isStandingOnLast() {
        return this.isStandingOnBlock(this.getLast());
    }

    boolean isStandingOnFirst() {
        return this.startBatchIndexInMemory <= 0;
    }

    boolean isStandingOnBlock(VectorSpillBlock block) {
        return block.startBatchIndex == this.startBatchIndexInMemory;
    }

    VectorSpillBlock getCurrentBlock() {
        VectorSpillBlock block;
        int spillBlockIndex = this.startBatchIndexInMemory / this.blockSize;
        if (spillBlockIndex > this.blocks.size() - 1) {
            this.LOG.debug("Creating new spill group for current buffered batches, block index: {}", (Object)spillBlockIndex);
            block = this.newBlock(spillBlockIndex);
            if (spillBlockIndex > 0) {
                block.startRowIndex[0] = (int)((long)this.blocks.get((int)(spillBlockIndex - 1)).startRowIndex[0] + this.blocks.get((int)(spillBlockIndex - 1)).spillRowCount);
            }
            this.blocks.add(block);
        } else {
            block = this.blocks.get(spillBlockIndex);
        }
        return block;
    }

    private VectorSpillBlock newBlock(int spillBlockIndex) {
        return new VectorSpillBlock(spillBlockIndex);
    }

    class VectorSpillBlock {
        final int blockIndex;
        @VisibleForTesting
        boolean didSpillToDisk;
        @VisibleForTesting
        long spillRowCount;
        int spillBatchCount;
        final int startBatchIndex;
        int[] startRowIndex;
        boolean[] isLastGroupBatch;
        boolean[] isInputExpressionEvaluated;
        private boolean doFinalRead = false;
        private VectorRowBytesContainer spillRowBytesContainer;
        private transient VectorSerializeRow bufferedBatchVectorSerializeRow;
        private transient VectorDeserializeRow bufferedBatchVectorDeserializeRow;

        VectorSpillBlock(int blockIndex) {
            this.blockIndex = blockIndex;
            this.startBatchIndex = blockIndex * VectorSpillBlockContainer.this.blockSize;
            this.startRowIndex = new int[VectorSpillBlockContainer.this.blockSize];
            this.isLastGroupBatch = new boolean[VectorSpillBlockContainer.this.blockSize];
            this.isInputExpressionEvaluated = new boolean[VectorSpillBlockContainer.this.blockSize];
        }

        void releaseRowBytesContainer() {
            if (this.spillRowBytesContainer != null) {
                this.spillRowBytesContainer.clear();
                this.spillRowBytesContainer = null;
            }
        }

        VectorRowBytesContainer getSpillRowBytesContainer() throws HiveException {
            if (this.spillRowBytesContainer == null) {
                this.spillRowBytesContainer = new VectorRowBytesContainer(VectorSpillBlockContainer.this.spillLocalDirs);
                if (this.bufferedBatchVectorSerializeRow == null) {
                    this.initSerialization();
                }
            }
            return this.spillRowBytesContainer;
        }

        VectorSerializeRow getVectorSerializeRow() throws HiveException {
            if (this.bufferedBatchVectorSerializeRow == null) {
                this.initSerialization();
            }
            return this.bufferedBatchVectorSerializeRow;
        }

        private void initSerialization() throws HiveException {
            this.initVectorSerializeRow();
            this.initVectorDeserializeRow();
        }

        private void initVectorSerializeRow() throws HiveException {
            this.bufferedBatchVectorSerializeRow = new VectorSerializeRow<LazyBinarySerializeWrite>(new LazyBinarySerializeWrite(VectorSpillBlockContainer.this.bufferedColumnMap.length));
            this.bufferedBatchVectorSerializeRow.init(VectorSpillBlockContainer.this.bufferedTypeInfos);
        }

        private void initVectorDeserializeRow() throws HiveException {
            this.bufferedBatchVectorDeserializeRow = new VectorDeserializeRow<LazyBinaryDeserializeRead>(new LazyBinaryDeserializeRead(VectorSpillBlockContainer.this.bufferedTypeInfos, true));
            this.bufferedBatchVectorDeserializeRow.init(this.doFinalRead ? VectorSpillBlockContainer.this.bufferedColumnMap : IntStream.range(0, VectorSpillBlockContainer.this.bufferedColumnMap.length).toArray());
        }

        public boolean isEmpty() {
            return this.spillRowCount == 0L;
        }

        public void setDoFinalRead(boolean doFinalRead) throws HiveException {
            this.doFinalRead = doFinalRead;
            this.initVectorDeserializeRow();
        }

        public String toString() {
            return String.format("[%s: blockIndex: %d, startBatchIndex: %d, startRowIndex: %s, spilled: %s, spillBatchCount: %d, spillRowCount: %d]", this.getClass().getSimpleName(), this.blockIndex, this.startBatchIndex, Arrays.toString(this.startRowIndex), this.didSpillToDisk, this.spillBatchCount, this.spillRowCount);
        }

        public void cleanup() {
            this.releaseRowBytesContainer();
        }

        public boolean isFullySpilled() {
            return this.didSpillToDisk && this.spillBatchCount == VectorSpillBlockContainer.this.blockSize;
        }

        public int getLastRowIndex() {
            return (int)((long)this.startRowIndex[0] + this.spillRowCount - 1L);
        }

        public VectorDeserializeRow getBufferedBatchVectorDeserializeRow() {
            return this.bufferedBatchVectorDeserializeRow;
        }

        public void spillBatch(BufferedVectorizedRowBatch batch) throws HiveException {
            VectorRowBytesContainer rowBytesContainer = this.getSpillRowBytesContainer();
            VectorSerializeRow vectorSerializeRow = this.getVectorSerializeRow();
            boolean selectedInUse = batch.selectedInUse;
            int[] selected = batch.selected;
            int size = batch.size;
            try {
                for (int logicalIndex = 0; logicalIndex < size; ++logicalIndex) {
                    int batchIndex = selectedInUse ? selected[logicalIndex] : logicalIndex;
                    ByteStream.Output output = rowBytesContainer.getOutputForRowBytes();
                    vectorSerializeRow.setOutputAppend(output);
                    vectorSerializeRow.serializeWrite(batch, batchIndex);
                    rowBytesContainer.finishRow();
                }
            }
            catch (IOException e) {
                throw new HiveException((Throwable)e);
            }
        }

        public void readSingleRowFromBytesContainer(VectorizedRowBatch batch) throws HiveException {
            VectorRowBytesContainer rowBytesContainer = this.getSpillRowBytesContainer();
            VectorDeserializeRow vectorDeserializeRow = this.getBufferedBatchVectorDeserializeRow();
            byte[] bytes = rowBytesContainer.currentBytes();
            int offset = rowBytesContainer.currentOffset();
            int length = rowBytesContainer.currentLength();
            vectorDeserializeRow.setBytes(bytes, offset, length);
            try {
                vectorDeserializeRow.deserialize(batch, batch.size);
            }
            catch (Exception e) {
                throw new HiveException("\nDeserializeRead detail: " + vectorDeserializeRow.getDetailedReadPositionString(), (Throwable)e);
            }
        }
    }
}

