/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.ptf;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.primitives.Ints;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.DataTypePhysicalVariation;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContextRegion;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedBatchUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorBase;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFGroupBatches;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PTFDesc;
import org.apache.hadoop.hive.ql.plan.VectorDesc;
import org.apache.hadoop.hive.ql.plan.VectorPTFDesc;
import org.apache.hadoop.hive.ql.plan.VectorPTFInfo;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorPTFOperator
extends Operator<PTFDesc>
implements VectorizationOperator,
VectorizationContextRegion {
    private static final long serialVersionUID = 1L;
    private static final String CLASS_NAME = VectorPTFOperator.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);
    private int[] scratchColumnPositions;
    private VectorizationContext vContext;
    private VectorPTFDesc vectorDesc;
    private VectorPTFInfo vectorPTFInfo;
    protected VectorizationContext vOutContext;
    private boolean isPartitionOrderBy;
    private TypeInfo[] reducerBatchTypeInfos;
    private int[] outputProjectionColumnMap;
    private String[] outputColumnNames;
    private TypeInfo[] outputTypeInfos;
    private DataTypePhysicalVariation[] outputDataTypePhysicalVariations;
    private int evaluatorCount;
    private String[] evaluatorFunctionNames;
    private int[] orderColumnMap;
    private ColumnVector.Type[] orderColumnVectorTypes;
    private VectorExpression[] orderExpressions;
    private int[] partitionColumnMap;
    private ColumnVector.Type[] partitionColumnVectorTypes;
    private VectorExpression[] partitionExpressions;
    private int[] keyInputColumnMap;
    private int[] nonKeyInputColumnMap;
    private transient boolean isLastGroupBatch;
    private transient VectorizedRowBatch overflowBatch;
    private transient VectorPTFGroupBatches groupBatches;
    private transient VectorPTFEvaluatorBase[] evaluators;
    private transient int[] streamingEvaluatorNums;
    private transient boolean allEvaluatorsAreStreaming;
    private transient boolean isFirstPartition;
    private transient boolean[] currentPartitionIsNull;
    private transient long[] currentPartitionLongs;
    private transient double[] currentPartitionDoubles;
    private transient byte[][] currentPartitionByteArrays;
    private transient int[] currentPartitionByteLengths;
    private transient HiveDecimalWritable[] currentPartitionDecimals;
    private transient Timestamp[] currentPartitionTimestamps;
    private transient HiveIntervalDayTime[] currentPartitionIntervalDayTimes;
    private transient int[] bufferedColumnMap;
    private transient TypeInfo[] bufferedTypeInfos;
    private transient String taskName;
    private transient long batchCounter;

    protected VectorPTFOperator() {
    }

    public VectorPTFOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    public VectorPTFOperator(CompilationOpContext ctx, OperatorDesc conf, VectorizationContext vContext, VectorDesc vectorDesc) throws HiveException {
        this(ctx);
        LOG.info("VectorPTF constructor");
        PTFDesc desc = (PTFDesc)conf;
        this.conf = desc;
        this.vectorDesc = (VectorPTFDesc)vectorDesc;
        this.vectorPTFInfo = this.vectorDesc.getVectorPTFInfo();
        this.vContext = vContext;
        this.reducerBatchTypeInfos = this.vectorDesc.getReducerBatchTypeInfos();
        this.isPartitionOrderBy = this.vectorDesc.getIsPartitionOrderBy();
        this.outputColumnNames = this.vectorDesc.getOutputColumnNames();
        this.outputTypeInfos = this.vectorDesc.getOutputTypeInfos();
        this.outputDataTypePhysicalVariations = this.vectorDesc.getOutputDataTypePhysicalVariations();
        this.outputProjectionColumnMap = this.vectorPTFInfo.getOutputColumnMap();
        this.vOutContext = new VectorizationContext(this.getName(), this.vContext);
        this.setupVOutContext();
        this.evaluatorFunctionNames = this.vectorDesc.getEvaluatorFunctionNames();
        this.evaluatorCount = this.evaluatorFunctionNames.length;
        this.orderColumnMap = this.vectorPTFInfo.getOrderColumnMap();
        this.orderColumnVectorTypes = this.vectorPTFInfo.getOrderColumnVectorTypes();
        this.orderExpressions = this.vectorPTFInfo.getOrderExpressions();
        this.partitionColumnMap = this.vectorPTFInfo.getPartitionColumnMap();
        this.partitionColumnVectorTypes = this.vectorPTFInfo.getPartitionColumnVectorTypes();
        this.partitionExpressions = this.vectorPTFInfo.getPartitionExpressions();
        this.keyInputColumnMap = this.vectorPTFInfo.getKeyInputColumnMap();
        this.nonKeyInputColumnMap = this.vectorPTFInfo.getNonKeyInputColumnMap();
    }

    protected void setupVOutContext() {
        this.vOutContext.resetProjectionColumns();
        int count = this.outputColumnNames.length;
        for (int i = 0; i < count; ++i) {
            String columnName = this.outputColumnNames[i];
            int outputColumn = this.outputProjectionColumnMap[i];
            this.vOutContext.addProjectionColumn(columnName, outputColumn);
        }
    }

    private static void allocateOverflowBatchColumnVector(VectorizedRowBatch overflowBatch, int outputColumn, String typeName, DataTypePhysicalVariation dataTypePhysicalVariation) throws HiveException {
        if (overflowBatch.cols[outputColumn] == null) {
            typeName = VectorizationContext.mapTypeNameSynonyms(typeName);
            TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)typeName);
            overflowBatch.cols[outputColumn] = VectorizedBatchUtil.createColumnVector(typeInfo, dataTypePhysicalVariation);
        }
    }

    @VisibleForTesting
    VectorizedRowBatch setupOverflowBatch(int firstOutputColumnIndex, String[] scratchColumnTypeNames, int[] outputProjectionColumnMap, TypeInfo[] outputTypeInfos) throws HiveException {
        int initialColumnCount = firstOutputColumnIndex;
        int totalNumColumns = initialColumnCount + scratchColumnTypeNames.length;
        VectorizedRowBatch overflowBatch = new VectorizedRowBatch(totalNumColumns);
        for (int i = 0; i < outputProjectionColumnMap.length; ++i) {
            int outputColumn = outputProjectionColumnMap[i];
            String typeName = outputTypeInfos[i].getTypeName();
            VectorPTFOperator.allocateOverflowBatchColumnVector(overflowBatch, outputColumn, typeName, this.vOutContext.getDataTypePhysicalVariation(outputColumn));
        }
        int outputColumn = initialColumnCount;
        int s = 0;
        this.scratchColumnPositions = new int[scratchColumnTypeNames.length];
        for (String typeName : scratchColumnTypeNames) {
            VectorPTFOperator.allocateOverflowBatchColumnVector(overflowBatch, outputColumn, typeName, this.vOutContext.getDataTypePhysicalVariation(outputColumn));
            this.scratchColumnPositions[s] = outputColumn++;
            ++s;
        }
        overflowBatch.projectedColumns = outputProjectionColumnMap;
        overflowBatch.projectionSize = outputProjectionColumnMap.length;
        overflowBatch.reset();
        return overflowBatch;
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        super.initializeOp(hconf);
        VectorExpression.doTransientInit(this.partitionExpressions, hconf);
        VectorExpression.doTransientInit(this.orderExpressions, hconf);
        if (LOG.isDebugEnabled()) {
            BaseWork work = Utilities.getMapWork(hconf);
            if (work == null) {
                work = Utilities.getReduceWork(hconf);
            }
            this.taskName = work.getName();
        }
        int partitionKeyCount = this.vectorDesc.getPartitionExprNodeDescs().length;
        this.currentPartitionIsNull = new boolean[partitionKeyCount];
        this.currentPartitionLongs = new long[partitionKeyCount];
        this.currentPartitionDoubles = new double[partitionKeyCount];
        this.currentPartitionByteArrays = new byte[partitionKeyCount][];
        this.currentPartitionByteLengths = new int[partitionKeyCount];
        this.currentPartitionDecimals = new HiveDecimalWritable[partitionKeyCount];
        this.currentPartitionTimestamps = new Timestamp[partitionKeyCount];
        this.currentPartitionIntervalDayTimes = new HiveIntervalDayTime[partitionKeyCount];
        this.overflowBatch = this.setupOverflowBatch(this.vContext.firstOutputColumnIndex(), this.vOutContext.getScratchColumnTypeNames(), this.outputProjectionColumnMap, this.outputTypeInfos);
        for (VectorPTFEvaluatorBase evaluator : this.evaluators = VectorPTFDesc.getEvaluators(this.vectorDesc, this.vectorPTFInfo)) {
            evaluator.setNullsLast(HiveConf.getBoolVar((Configuration)hconf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DEFAULT_NULLS_LAST));
        }
        this.streamingEvaluatorNums = VectorPTFDesc.getStreamingEvaluatorNums(this.evaluators);
        this.allEvaluatorsAreStreaming = this.streamingEvaluatorNums.length == this.evaluatorCount;
        this.groupBatches = new VectorPTFGroupBatches(hconf, this.vectorDesc.getVectorizedPTFMaxMemoryBufferingBatchCount());
        this.initBufferedColumns();
        this.initExpressionColumns();
        int[] keyWithoutOrderColumnMap = this.determineKeyColumnsWithoutOrderColumns(this.keyInputColumnMap, this.orderColumnMap);
        this.groupBatches.init(this.evaluators, this.outputProjectionColumnMap, this.bufferedColumnMap, this.bufferedTypeInfos, this.orderColumnMap, keyWithoutOrderColumnMap, this.overflowBatch);
        this.isFirstPartition = true;
        this.batchCounter = 0L;
    }

    @Override
    public void setNextVectorBatchGroupStatus(boolean isLastGroupBatch) throws HiveException {
        this.isLastGroupBatch = isLastGroupBatch;
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        VectorizedRowBatch batch = (VectorizedRowBatch)row;
        for (VectorExpression orderExpression : this.orderExpressions) {
            orderExpression.evaluate(batch);
        }
        if (this.partitionExpressions != null) {
            for (VectorExpression partitionExpression : this.partitionExpressions) {
                partitionExpression.evaluate(batch);
            }
        }
        if (this.isFirstPartition) {
            this.isFirstPartition = false;
            this.setCurrentPartition(batch);
        } else if (this.isPartitionChanged(batch)) {
            if (!this.allEvaluatorsAreStreaming) {
                this.finishPartition(this.getPartitionKey());
            }
            this.setCurrentPartition(batch);
            this.groupBatches.resetEvaluators();
        }
        if (this.allEvaluatorsAreStreaming) {
            this.groupBatches.evaluateStreamingGroupBatch(batch, this.isLastGroupBatch);
            this.vectorForward(batch);
        } else {
            this.groupBatches.bufferGroupBatch(batch, this.isLastGroupBatch);
        }
        if (!this.isPartitionOrderBy && this.isLastGroupBatch) {
            this.groupBatches.resetEvaluators();
        }
    }

    private void initBufferedColumns() {
        int bufferedMapIndex;
        int columnNum;
        int i;
        int bufferedColumnCount = this.orderColumnMap.length + this.nonKeyInputColumnMap.length + this.streamingEvaluatorNums.length + this.scratchColumnPositions.length;
        this.bufferedColumnMap = new int[bufferedColumnCount];
        this.bufferedTypeInfos = new TypeInfo[bufferedColumnCount];
        int orderColumnCount = this.orderColumnMap.length;
        int nonKeyInputColumnCount = this.nonKeyInputColumnMap.length;
        int streamingEvaluatorCount = this.streamingEvaluatorNums.length;
        for (i = 0; i < this.orderColumnMap.length; ++i) {
            this.bufferedColumnMap[i] = columnNum = this.orderColumnMap[i];
            this.bufferedTypeInfos[i] = this.reducerBatchTypeInfos.length <= columnNum ? VectorPTFOperator.columnVectorTypeToTypeInfo(this.orderColumnVectorTypes[i]) : this.reducerBatchTypeInfos[columnNum];
        }
        for (i = 0; i < this.nonKeyInputColumnMap.length; ++i) {
            columnNum = this.nonKeyInputColumnMap[i];
            bufferedMapIndex = orderColumnCount + i;
            this.bufferedColumnMap[bufferedMapIndex] = columnNum;
            this.bufferedTypeInfos[bufferedMapIndex] = this.reducerBatchTypeInfos[columnNum];
        }
        for (i = 0; i < streamingEvaluatorCount; ++i) {
            int streamingEvaluatorNum = this.streamingEvaluatorNums[i];
            bufferedMapIndex = orderColumnCount + nonKeyInputColumnCount + i;
            this.bufferedColumnMap[bufferedMapIndex] = this.outputProjectionColumnMap[streamingEvaluatorNum];
            this.bufferedTypeInfos[bufferedMapIndex] = this.outputTypeInfos[streamingEvaluatorNum];
        }
        for (i = 0; i < this.scratchColumnPositions.length; ++i) {
            int bufferedMapIndex2 = orderColumnCount + nonKeyInputColumnCount + streamingEvaluatorCount + i;
            this.bufferedColumnMap[bufferedMapIndex2] = this.scratchColumnPositions[i];
            this.bufferedTypeInfos[bufferedMapIndex2] = TypeInfoUtils.getTypeInfoFromTypeString((String)this.vOutContext.getScratchColumnTypeNames()[i]);
        }
    }

    private void initExpressionColumns() {
        for (int i = 0; i < this.evaluators.length; ++i) {
            VectorPTFEvaluatorBase evaluator = this.evaluators[i];
            if (evaluator.streamsResult()) continue;
            evaluator.inputColumnNum = IntStream.range(0, this.bufferedColumnMap.length).filter(j -> this.bufferedColumnMap[j] == evaluator.inputColumnNum).findFirst().orElseGet(() -> evaluator.inputColumnNum);
            if (evaluator.inputVecExpr != null) {
                int j2 = 0;
                while (j2 < evaluator.inputVecExpr.inputColumnNum.length) {
                    int jj = j2++;
                    evaluator.inputVecExpr.inputColumnNum[jj] = IntStream.range(0, this.bufferedColumnMap.length).filter(k -> this.bufferedColumnMap[k] == evaluator.inputVecExpr.inputColumnNum[jj]).findFirst().orElseGet(() -> evaluator.inputVecExpr.inputColumnNum[jj]);
                }
                evaluator.inputVecExpr.outputColumnNum = IntStream.range(0, this.bufferedColumnMap.length).filter(j -> this.bufferedColumnMap[j] == evaluator.inputVecExpr.outputColumnNum).findFirst().orElseGet(() -> evaluator.inputVecExpr.outputColumnNum);
            }
            evaluator.mapCustomColumns(this.bufferedColumnMap);
        }
    }

    private int[] determineKeyColumnsWithoutOrderColumns(int[] keyInputColumnMap, int[] orderColumnMap) {
        List keyColumnsWithoutOrderColumns = IntStream.of(keyInputColumnMap).boxed().collect(Collectors.toList());
        List orderColumns = IntStream.of(orderColumnMap).boxed().collect(Collectors.toList());
        keyColumnsWithoutOrderColumns.removeAll(orderColumns);
        return Ints.toArray(keyColumnsWithoutOrderColumns);
    }

    private static TypeInfo columnVectorTypeToTypeInfo(ColumnVector.Type type) {
        switch (type) {
            case DOUBLE: {
                return TypeInfoUtils.getTypeInfoFromTypeString((String)"double");
            }
            case BYTES: {
                return TypeInfoUtils.getTypeInfoFromTypeString((String)"string");
            }
            case DECIMAL: {
                return TypeInfoUtils.getTypeInfoFromTypeString((String)"decimal");
            }
            case TIMESTAMP: {
                return TypeInfoUtils.getTypeInfoFromTypeString((String)"timestamp");
            }
            case LONG: {
                return TypeInfoUtils.getTypeInfoFromTypeString((String)"int");
            }
        }
        throw new RuntimeException("Cannot convert column vector type: '" + String.valueOf(type) + "' to TypeInfo");
    }

    private Object[] getPartitionKey() {
        int count = this.partitionColumnMap.length;
        Object[] key = new Object[count];
        block8: for (int i = 0; i < count; ++i) {
            if (this.currentPartitionIsNull[i]) {
                key[i] = null;
                continue;
            }
            switch (this.partitionColumnVectorTypes[i]) {
                case LONG: {
                    key[i] = this.currentPartitionLongs[i];
                    continue block8;
                }
                case DOUBLE: {
                    key[i] = this.currentPartitionDoubles[i];
                    continue block8;
                }
                case BYTES: {
                    key[i] = new byte[this.currentPartitionByteLengths[i]];
                    System.arraycopy(this.currentPartitionByteArrays[i], 0, key[i], 0, this.currentPartitionByteLengths[i]);
                    continue block8;
                }
                case DECIMAL: {
                    key[i] = this.currentPartitionDecimals[i];
                    continue block8;
                }
                case TIMESTAMP: {
                    key[i] = this.currentPartitionTimestamps[i];
                    continue block8;
                }
                case INTERVAL_DAY_TIME: {
                    key[i] = this.currentPartitionIntervalDayTimes[i];
                    continue block8;
                }
                default: {
                    throw new RuntimeException("Unexpected column vector type " + String.valueOf(this.partitionColumnVectorTypes[i]));
                }
            }
        }
        return key;
    }

    private void finishPartition(Object[] partitionKey) throws HiveException {
        this.groupBatches.finishPartition();
        this.groupBatches.fillGroupResultsAndForward(this, partitionKey);
        this.groupBatches.cleanupPartition();
    }

    private boolean isPartitionChanged(VectorizedRowBatch batch) {
        int count = this.partitionColumnMap.length;
        block8: for (int i = 0; i < count; ++i) {
            boolean currentIsNull;
            ColumnVector colVector = batch.cols[this.partitionColumnMap[i]];
            boolean isNull = !colVector.noNulls && colVector.isNull[0];
            if (isNull != (currentIsNull = this.currentPartitionIsNull[i])) {
                return true;
            }
            if (isNull) continue;
            switch (this.partitionColumnVectorTypes[i]) {
                case LONG: {
                    if (this.currentPartitionLongs[i] == ((LongColumnVector)colVector).vector[0]) continue block8;
                    return true;
                }
                case DOUBLE: {
                    if (this.currentPartitionDoubles[i] == ((DoubleColumnVector)colVector).vector[0]) continue block8;
                    return true;
                }
                case BYTES: {
                    BytesColumnVector byteColVector = (BytesColumnVector)colVector;
                    byte[] bytes = byteColVector.vector[0];
                    int start = byteColVector.start[0];
                    int length = byteColVector.length[0];
                    if (StringExpr.equal((byte[])bytes, (int)start, (int)length, (byte[])this.currentPartitionByteArrays[i], (int)0, (int)this.currentPartitionByteLengths[i])) continue block8;
                    return true;
                }
                case DECIMAL: {
                    if (this.currentPartitionDecimals[i].equals((Object)((DecimalColumnVector)colVector).vector[0])) continue block8;
                    return true;
                }
                case TIMESTAMP: {
                    if (((TimestampColumnVector)colVector).compareTo(0, this.currentPartitionTimestamps[i]) == 0) continue block8;
                    return true;
                }
                case INTERVAL_DAY_TIME: {
                    if (((IntervalDayTimeColumnVector)colVector).compareTo(0, this.currentPartitionIntervalDayTimes[i]) == 0) continue block8;
                    return true;
                }
                default: {
                    throw new RuntimeException("Unexpected column vector type " + String.valueOf(this.partitionColumnVectorTypes[i]));
                }
            }
        }
        return false;
    }

    private void setCurrentPartition(VectorizedRowBatch batch) {
        int count = this.partitionColumnMap.length;
        block8: for (int i = 0; i < count; ++i) {
            boolean isNull;
            ColumnVector colVector = batch.cols[this.partitionColumnMap[i]];
            this.currentPartitionIsNull[i] = isNull = !colVector.noNulls && colVector.isNull[0];
            if (isNull) continue;
            switch (this.partitionColumnVectorTypes[i]) {
                case LONG: {
                    this.currentPartitionLongs[i] = ((LongColumnVector)colVector).vector[0];
                    continue block8;
                }
                case DOUBLE: {
                    this.currentPartitionDoubles[i] = ((DoubleColumnVector)colVector).vector[0];
                    continue block8;
                }
                case BYTES: {
                    BytesColumnVector byteColVector = (BytesColumnVector)colVector;
                    byte[] bytes = byteColVector.vector[0];
                    int start = byteColVector.start[0];
                    int length = byteColVector.length[0];
                    if (this.currentPartitionByteArrays[i] == null || this.currentPartitionByteLengths[i] < length) {
                        this.currentPartitionByteArrays[i] = Arrays.copyOfRange(bytes, start, start + length);
                    } else {
                        System.arraycopy(bytes, start, this.currentPartitionByteArrays[i], 0, length);
                    }
                    this.currentPartitionByteLengths[i] = length;
                    continue block8;
                }
                case DECIMAL: {
                    if (this.currentPartitionDecimals[i] == null) {
                        this.currentPartitionDecimals[i] = new HiveDecimalWritable();
                    }
                    this.currentPartitionDecimals[i].set(((DecimalColumnVector)colVector).vector[0]);
                    continue block8;
                }
                case TIMESTAMP: {
                    if (this.currentPartitionTimestamps[i] == null) {
                        this.currentPartitionTimestamps[i] = new Timestamp(0L);
                    }
                    ((TimestampColumnVector)colVector).timestampUpdate(this.currentPartitionTimestamps[i], 0);
                    continue block8;
                }
                case INTERVAL_DAY_TIME: {
                    if (this.currentPartitionIntervalDayTimes[i] == null) {
                        this.currentPartitionIntervalDayTimes[i] = new HiveIntervalDayTime();
                    }
                    ((IntervalDayTimeColumnVector)colVector).intervalDayTimeUpdate(this.currentPartitionIntervalDayTimes[i], 0);
                    continue block8;
                }
                default: {
                    throw new RuntimeException("Unexpected column vector type " + String.valueOf(this.partitionColumnVectorTypes[i]));
                }
            }
        }
    }

    void forwardBatch(VectorizedRowBatch batch) throws HiveException {
        super.vectorForward(batch);
    }

    @Override
    protected void closeOp(boolean abort) throws HiveException {
        if (!(abort || this.allEvaluatorsAreStreaming || this.isFirstPartition)) {
            this.finishPartition(this.getPartitionKey());
        }
        super.closeOp(abort);
    }

    @Override
    public String getName() {
        return VectorPTFOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "PTF";
    }

    @Override
    public OperatorType getType() {
        return OperatorType.PTF;
    }

    @Override
    public VectorizationContext getOutputVectorizationContext() {
        return this.vOutContext;
    }

    @Override
    public VectorizationContext getInputVectorizationContext() {
        return this.vContext;
    }

    @Override
    public VectorDesc getVectorDesc() {
        return this.vectorDesc;
    }
}

