/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class LongColGreaterLongScalar
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    protected final long value;

    public LongColGreaterLongScalar(int colNum, long value, int outputColumnNum) {
        super(colNum, outputColumnNum);
        this.value = value;
    }

    public LongColGreaterLongScalar() {
        this.value = 0L;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        int n = batch.size;
        if (n == 0) {
            return;
        }
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector inputColVector = (LongColumnVector)batch.cols[this.inputColumnNum[0]];
        LongColumnVector outputColVector = (LongColumnVector)batch.cols[this.outputColumnNum];
        int[] sel = batch.selected;
        boolean[] inputIsNull = inputColVector.isNull;
        boolean[] outputIsNull = outputColVector.isNull;
        outputColVector.isRepeating = false;
        long[] vector = inputColVector.vector;
        long[] outputVector = outputColVector.vector;
        if (inputColVector.isRepeating) {
            if (inputColVector.noNulls || !inputIsNull[0]) {
                outputIsNull[0] = false;
                outputVector[0] = vector[0] > this.value ? 1L : 0L;
            } else {
                outputIsNull[0] = true;
                outputColVector.noNulls = false;
            }
            outputColVector.isRepeating = true;
            return;
        }
        if (inputColVector.noNulls) {
            if (batch.selectedInUse) {
                if (!outputColVector.noNulls) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputIsNull[i] = false;
                        outputVector[i] = vector[i] > this.value ? 1L : 0L;
                    }
                } else {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputVector[i] = vector[i] > this.value ? 1L : 0L;
                    }
                }
            } else {
                if (!outputColVector.noNulls) {
                    Arrays.fill(outputIsNull, false);
                    outputColVector.noNulls = true;
                }
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = vector[i] > this.value ? 1L : 0L;
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (!inputIsNull[i]) {
                    outputIsNull[i] = false;
                    outputVector[i] = vector[i] > this.value ? 1L : 0L;
                    continue;
                }
                outputIsNull[i] = true;
                outputColVector.noNulls = false;
            }
        } else {
            for (int i = 0; i != n; ++i) {
                if (!inputIsNull[i]) {
                    outputIsNull[i] = false;
                    outputVector[i] = vector[i] > this.value ? 1L : 0L;
                    continue;
                }
                outputIsNull[i] = true;
                outputColVector.noNulls = false;
            }
        }
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.inputColumnNum[0]) + ", val " + this.value;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("long"), VectorExpressionDescriptor.ArgumentType.getType("long")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR).build();
    }
}

