/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public abstract class IfExprCondExprBase
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    protected transient boolean isIfStatementResultRepeated;
    protected transient boolean isIfStatementResultThen;
    protected transient int thenSelectedCount;
    protected transient int[] thenSelected;
    protected transient int elseSelectedCount;
    protected transient int[] elseSelected;

    public IfExprCondExprBase(int arg1Column, int outputColumnNum) {
        super(arg1Column, outputColumnNum);
    }

    public IfExprCondExprBase(int arg1Column, int arg2Column, int outputColumnNum) {
        super(arg1Column, arg2Column, outputColumnNum);
    }

    public IfExprCondExprBase(int arg1Column, int arg2Column, int arg3Column, int outputColumnNum) {
        super(arg1Column, arg2Column, arg3Column, outputColumnNum);
    }

    public IfExprCondExprBase() {
    }

    public void conditionalEvaluate(VectorizedRowBatch batch, VectorExpression condVecExpr, int[] condSelected, int condSize) throws HiveException {
        int saveSize = batch.size;
        boolean saveSelectedInUse = batch.selectedInUse;
        int[] saveSelected = batch.selected;
        batch.size = condSize;
        batch.selectedInUse = true;
        batch.selected = condSelected;
        condVecExpr.evaluate(batch);
        batch.size = saveSize;
        batch.selectedInUse = saveSelectedInUse;
        batch.selected = saveSelected;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        this.thenSelectedCount = 0;
        this.elseSelectedCount = 0;
        this.isIfStatementResultRepeated = false;
        this.isIfStatementResultThen = false;
        int n = batch.size;
        if (n <= 0) {
            return;
        }
        this.childExpressions[0].evaluate(batch);
        LongColumnVector ifExprColVector = (LongColumnVector)batch.cols[this.inputColumnNum[0]];
        if (ifExprColVector.isRepeating) {
            this.isIfStatementResultRepeated = true;
            this.isIfStatementResultThen = (ifExprColVector.noNulls || !ifExprColVector.isNull[0]) && ifExprColVector.vector[0] == 1L;
            return;
        }
        if (this.thenSelected == null || n > this.thenSelected.length) {
            int roundUpSize = (n + 1024 - 1) / 1024 * 1024;
            this.thenSelected = new int[roundUpSize];
            this.elseSelected = new int[roundUpSize];
        }
        int[] sel = batch.selected;
        long[] vector = ifExprColVector.vector;
        if (ifExprColVector.noNulls) {
            if (batch.selectedInUse) {
                for (int j = 0; j < n; ++j) {
                    int i = sel[j];
                    if (vector[i] == 1L) {
                        this.thenSelected[this.thenSelectedCount++] = i;
                        continue;
                    }
                    this.elseSelected[this.elseSelectedCount++] = i;
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    if (vector[i] == 1L) {
                        this.thenSelected[this.thenSelectedCount++] = i;
                        continue;
                    }
                    this.elseSelected[this.elseSelectedCount++] = i;
                }
            }
        } else {
            boolean[] isNull = ifExprColVector.isNull;
            if (batch.selectedInUse) {
                for (int j = 0; j < n; ++j) {
                    int i = sel[j];
                    if (!isNull[i] && vector[i] == 1L) {
                        this.thenSelected[this.thenSelectedCount++] = i;
                        continue;
                    }
                    this.elseSelected[this.elseSelectedCount++] = i;
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    if (!isNull[i] && vector[i] == 1L) {
                        this.thenSelected[this.thenSelectedCount++] = i;
                        continue;
                    }
                    this.elseSelected[this.elseSelectedCount++] = i;
                }
            }
        }
        if (this.thenSelectedCount == 0) {
            this.isIfStatementResultRepeated = true;
            this.isIfStatementResultThen = false;
        } else if (this.elseSelectedCount == 0) {
            this.isIfStatementResultRepeated = true;
            this.isIfStatementResultThen = true;
        }
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        throw new UnsupportedOperationException("Undefined descriptor");
    }
}

