/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.tez.dag.api.Scope;
import org.apache.tez.dag.api.TezConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TezConfigurationFactory {
    private static TezConfiguration defaultConf = new TezConfiguration();
    private static final Field updatingResource;
    private static final Logger LOG;

    public static Configuration copyInto(Configuration target, Configuration src, Predicate<String> sourceFilter) {
        for (Map.Entry entry : src) {
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            String[] sources = TezConfigurationFactory.getPropertyUpdatingResources(src, name);
            String source = TezConfigurationFactory.resolveFirstUpdatingResource(sources);
            if (sourceFilter == null || sourceFilter.test(source)) {
                target.set(name, value, source);
                continue;
            }
            LOG.debug("'{}' didn't pass filter, skipping adding it", (Object)name);
        }
        return target;
    }

    public static JobConf wrapWithJobConf(Configuration conf, Predicate<String> sourceFilter) {
        JobConf jc = new JobConf(false);
        TezConfigurationFactory.copyInto((Configuration)jc, (Configuration)defaultConf, sourceFilter);
        TezConfigurationFactory.copyInto((Configuration)jc, conf, sourceFilter);
        return jc;
    }

    public static void addProgrammaticallyAddedTezOptsToDagConf(Map<String, String> dagConf, JobConf srcConf) {
        for (Map.Entry entry : srcConf) {
            String name = (String)entry.getKey();
            if (!name.startsWith("tez")) continue;
            String value = (String)entry.getValue();
            String[] sources = TezConfigurationFactory.getPropertyUpdatingResources((Configuration)srcConf, name);
            String source = TezConfigurationFactory.resolveFirstUpdatingResource(sources);
            if (!"programmatically".equalsIgnoreCase(source)) continue;
            try {
                TezConfiguration.validateProperty((String)name, (Scope)Scope.DAG);
                LOG.debug("Adding programmatically set config to dag: {}={}", (Object)name, (Object)value);
                dagConf.put(name, value);
            }
            catch (IllegalStateException e) {
                LOG.warn("Skip adding '{}' to dagConf, as it's an AM scoped property", (Object)name);
            }
        }
    }

    private static String[] getPropertyUpdatingResources(Configuration src, String name) {
        String[] sources;
        try {
            sources = (String[])((Map)updatingResource.get(src)).get(name);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        return sources;
    }

    private static String resolveFirstUpdatingResource(String[] sources) {
        String source = sources == null || sources.length == 0 ? null : sources[sources.length - 1];
        return source;
    }

    static {
        LOG = LoggerFactory.getLogger((String)TezConfigurationFactory.class.getName());
        String sslConf = defaultConf.get("hadoop.ssl.client.conf", "ssl-client.xml");
        defaultConf.addResource(sslConf);
        LOG.info("SSL conf : " + sslConf);
        try {
            updatingResource = Configuration.class.getDeclaredField("updatingResource");
        }
        catch (NoSuchFieldException | SecurityException e) {
            throw new RuntimeException(e);
        }
        updatingResource.setAccessible(true);
    }
}

