/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl.incremental;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.repl.ReplAck;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.repl.dump.EventsDumpMetadata;
import org.apache.hadoop.hive.ql.parse.repl.load.EventDumpDirComparator;

public class IncrementalLoadEventsIterator
implements Iterator<FileStatus> {
    private FileStatus[] eventDirs;
    private int currentIndex;
    private int numEvents;
    private int totalEventsCount;
    private boolean eventsBatched;
    private Iterator<FileStatus> eventBatchDirsIterator;
    private FileSystem fs;

    public IncrementalLoadEventsIterator(String loadPath, HiveConf conf) throws IOException, HiveException {
        Path eventPath = new Path(loadPath);
        this.fs = eventPath.getFileSystem((Configuration)conf);
        Path eventsDumpAckFile = new Path(eventPath, ReplAck.EVENTS_DUMP.toString());
        this.eventDirs = this.fs.listStatus(eventPath, ReplUtils.getEventsDirectoryFilter(this.fs));
        if (this.eventDirs == null || this.eventDirs.length == 0) {
            this.totalEventsCount = 0;
            this.numEvents = 0;
            this.currentIndex = 0;
            return;
        }
        EventsDumpMetadata eventsDumpMetadata = EventsDumpMetadata.deserialize(eventsDumpAckFile, conf);
        this.eventsBatched = eventsDumpMetadata.isEventsBatched();
        this.totalEventsCount = this.eventDirs.length;
        if (this.eventsBatched) {
            Arrays.sort(this.eventDirs, new EventDumpDirComparator());
            this.eventBatchDirsIterator = Arrays.stream(this.eventDirs).iterator();
            this.eventDirs = this.fs.listStatus(this.eventBatchDirsIterator.next().getPath(), ReplUtils.getEventsDirectoryFilter(this.fs));
            this.totalEventsCount = eventsDumpMetadata.getEventsDumpedCount();
        }
        Arrays.sort(this.eventDirs, new EventDumpDirComparator());
        this.currentIndex = 0;
        this.numEvents = this.eventDirs.length;
    }

    @Override
    public boolean hasNext() {
        return this.eventDirs != null && this.currentIndex < this.numEvents;
    }

    private boolean hasNextBatch() {
        return this.eventBatchDirsIterator.hasNext();
    }

    @Override
    public FileStatus next() {
        if (this.eventsBatched) {
            FileStatus event = this.eventDirs[this.currentIndex++];
            if (this.hasNextBatch() && this.currentIndex == this.numEvents) {
                try {
                    this.eventDirs = this.fs.listStatus(this.eventBatchDirsIterator.next().getPath(), ReplUtils.getEventsDirectoryFilter(this.fs));
                    Arrays.sort(this.eventDirs, new EventDumpDirComparator());
                    this.currentIndex = 0;
                    this.numEvents = this.eventDirs.length;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return event;
        }
        if (this.hasNext()) {
            return this.eventDirs[this.currentIndex++];
        }
        throw new NoSuchElementException("no more events");
    }

    public int getTotalEventsCount() {
        return this.totalEventsCount;
    }
}

