/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl;

import java.io.Serializable;
import java.net.URL;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.parse.repl.metric.ReplicationMetricCollector;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Explain(displayName="Ranger Deny Policy Operator", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class RangerDenyWork
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(RangerDenyWork.class);
    private Path currentDumpPath;
    private String targetDbName;
    private String sourceDbName;
    private final transient ReplicationMetricCollector metricCollector;

    public RangerDenyWork(Path currentDumpPath, String sourceDbName, String targetDbName, ReplicationMetricCollector metricCollector) {
        this.currentDumpPath = currentDumpPath;
        this.targetDbName = targetDbName;
        this.sourceDbName = sourceDbName;
        this.metricCollector = metricCollector;
    }

    public Path getCurrentDumpPath() {
        return this.currentDumpPath;
    }

    public String getTargetDbName() {
        return this.targetDbName;
    }

    public String getSourceDbName() {
        return this.sourceDbName;
    }

    URL getRangerConfigResource() {
        return this.getClass().getClassLoader().getResource("ranger-hive-security.xml");
    }

    ReplicationMetricCollector getMetricCollector() {
        return this.metricCollector;
    }
}

