/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.persistence;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.persistence.RowContainer;
import org.apache.hadoop.hive.ql.io.HiveSequenceFileOutputFormat;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.PTFDeserializer;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinarySerDe;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileRecordReader;
import org.apache.hadoop.util.Progressable;

public class PTFRowContainer<Row extends List<Object>>
extends RowContainer<Row> {
    private ArrayList<BlockInfo> blockInfos = new ArrayList();
    private int currentReadBlockStartRow;

    public PTFRowContainer(int bs, Configuration jc, Reporter reporter) throws HiveException {
        super(bs, jc, reporter);
    }

    @Override
    public void addRow(Row t) throws HiveException {
        if (this.willSpill()) {
            this.setupWriter();
            PTFRecordWriter rw = (PTFRecordWriter)this.getRecordWriter();
            BlockInfo blkInfo = new BlockInfo();
            try {
                blkInfo.startOffset = rw.outStream.getLength();
                this.blockInfos.add(blkInfo);
            }
            catch (IOException e) {
                this.clearRows();
                LOG.error(e.toString(), (Throwable)e);
                throw new HiveException((Throwable)e);
            }
        }
        super.addRow(t);
    }

    @Override
    public Row first() throws HiveException {
        Object r = super.first();
        if (this.blockInfos.size() > 0) {
            InputSplit[] inputSplits = this.getInputSplits();
            FileSplit fS = null;
            BlockInfo bI = this.blockInfos.get(0);
            bI.startingSplit = 0;
            int i = 1;
            bI = i < this.blockInfos.size() ? this.blockInfos.get(i) : null;
            for (int j = 1; j < inputSplits.length && bI != null; ++j) {
                fS = (FileSplit)inputSplits[j];
                while (bI != null && bI.startOffset < fS.getStart()) {
                    bI.startingSplit = j - 1;
                    bI = ++i < this.blockInfos.size() ? this.blockInfos.get(i) : null;
                }
            }
            while (i < this.blockInfos.size()) {
                bI = this.blockInfos.get(i);
                bI.startingSplit = inputSplits.length - 1;
                ++i;
            }
        }
        this.currentReadBlockStartRow = 0;
        return (Row)r;
    }

    @Override
    public Row next() throws HiveException {
        boolean endOfCurrBlock = this.endOfCurrentReadBlock();
        if (endOfCurrBlock) {
            this.currentReadBlockStartRow += this.getCurrentReadBlockSize();
        }
        return (Row)super.next();
    }

    @Override
    public void clearRows() throws HiveException {
        super.clearRows();
        this.resetReadBlocks();
        this.blockInfos = new ArrayList();
    }

    @Override
    public void close() throws HiveException {
        super.close();
        this.blockInfos = null;
    }

    public Row getAt(int rowIdx) throws HiveException {
        int blockSize = this.getBlockSize();
        if (rowIdx < this.currentReadBlockStartRow || rowIdx >= this.currentReadBlockStartRow + blockSize) {
            this.readBlock(this.getBlockNum(rowIdx));
        }
        return (Row)this.getReadBlockRow(rowIdx - this.currentReadBlockStartRow);
    }

    private int numBlocks() {
        return this.blockInfos.size() + 1;
    }

    private int getBlockNum(int rowIdx) {
        int blockSize = this.getBlockSize();
        return rowIdx / blockSize;
    }

    private void readBlock(int blockNum) throws HiveException {
        this.currentReadBlockStartRow = this.getBlockSize() * blockNum;
        if (blockNum == this.numBlocks() - 1) {
            this.setWriteBlockAsReadBlock();
            return;
        }
        this.resetCurrentReadBlockToFirstReadBlock();
        BlockInfo bI = this.blockInfos.get(blockNum);
        int startSplit = bI.startingSplit;
        int endSplit = blockNum != this.blockInfos.size() - 1 ? this.blockInfos.get((int)(blockNum + 1)).startingSplit : this.getLastActualSplit();
        try {
            int readIntoOffset = 0;
            for (int i = startSplit; i <= endSplit && readIntoOffset < this.getBlockSize(); ++i) {
                RecordReader rr = this.setReaderAtSplit(i);
                if (i == startSplit) {
                    ((PTFSequenceFileRecordReader)rr).seek(bI.startOffset);
                }
                this.nextBlock(readIntoOffset);
                readIntoOffset = this.getCurrentReadBlockSize();
            }
        }
        catch (Exception e) {
            this.clearRows();
            LOG.error(e.toString(), (Throwable)e);
            if (e instanceof HiveException) {
                throw (HiveException)((Object)e);
            }
            throw new HiveException((Throwable)e);
        }
    }

    public static TableDesc createTableDesc(StructObjectInspector oI) {
        HashMap<String, String> props = new HashMap<String, String>();
        PTFDeserializer.addOIPropertiestoSerDePropsMap(oI, props);
        String colNames = (String)props.get("columns");
        String colTypes = (String)props.get("columns.types");
        TableDesc tblDesc = new TableDesc(PTFSequenceFileInputFormat.class, PTFHiveSequenceFileOutputFormat.class, Utilities.makeProperties("serialization.format", "1", "columns", colNames.toString(), "columns.types", colTypes.toString(), "bucketing_version", "-1", "serialization.lib", LazyBinarySerDe.class.getName()));
        return tblDesc;
    }

    private static class PTFRecordWriter
    implements FileSinkOperator.RecordWriter {
        BytesWritable EMPTY_KEY = new BytesWritable();
        SequenceFile.Writer outStream;

        public PTFRecordWriter(SequenceFile.Writer outStream) {
            this.outStream = outStream;
        }

        @Override
        public void write(Writable r) throws IOException {
            this.outStream.append((Writable)this.EMPTY_KEY, r);
        }

        @Override
        public void close(boolean abort) throws IOException {
            this.outStream.close();
        }
    }

    private static class BlockInfo {
        long startOffset;
        int startingSplit;

        private BlockInfo() {
        }
    }

    public static class PTFSequenceFileRecordReader<K, V>
    extends SequenceFileRecordReader<K, V> {
        public PTFSequenceFileRecordReader(Configuration conf, FileSplit split) throws IOException {
            super(conf, split);
        }

        public void seek(long pos) throws IOException {
            super.seek(pos);
        }
    }

    public static class PTFSequenceFileInputFormat<K, V>
    extends SequenceFileInputFormat<K, V> {
        public RecordReader<K, V> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
            reporter.setStatus(split.toString());
            return new PTFSequenceFileRecordReader((Configuration)job, (FileSplit)split);
        }
    }

    public static class PTFHiveSequenceFileOutputFormat<K, V>
    extends HiveSequenceFileOutputFormat<K, V> {
        @Override
        public FileSinkOperator.RecordWriter getHiveRecordWriter(JobConf jc, Path finalOutPath, Class<? extends Writable> valueClass, boolean isCompressed, Properties tableProperties, Progressable progress) throws IOException {
            FileSystem fs = finalOutPath.getFileSystem((Configuration)jc);
            SequenceFile.Writer outStream = Utilities.createSequenceWriter(jc, fs, finalOutPath, BytesWritable.class, valueClass, isCompressed, progress);
            return new PTFRecordWriter(outStream);
        }
    }
}

