/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.workloadmanagement.resourceplan.show.formatter;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.WMFullResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMResourcePlan;
import org.apache.hadoop.hive.ql.ddl.workloadmanagement.resourceplan.show.formatter.ShowResourcePlanFormatter;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class JsonShowResourcePlanFormatter
extends ShowResourcePlanFormatter {
    @Override
    public void showResourcePlans(DataOutputStream out, List<WMResourcePlan> resourcePlans) throws HiveException {
        try (JsonGenerator generator = new ObjectMapper().getFactory().createJsonGenerator((OutputStream)out);){
            generator.writeStartArray();
            for (WMResourcePlan plan : resourcePlans) {
                generator.writeStartObject();
                generator.writeStringField("name", plan.getName());
                generator.writeStringField("status", plan.getStatus().name());
                if (plan.isSetQueryParallelism()) {
                    generator.writeNumberField("queryParallelism", plan.getQueryParallelism());
                }
                if (plan.isSetDefaultPoolPath()) {
                    generator.writeStringField("defaultPoolPath", plan.getDefaultPoolPath());
                }
                generator.writeEndObject();
            }
            generator.writeEndArray();
            generator.close();
        }
        catch (IOException e) {
            throw new HiveException((Throwable)e);
        }
    }

    @Override
    public void showFullResourcePlan(DataOutputStream out, WMFullResourcePlan resourcePlan) throws HiveException {
        try (JsonRPFormatter formatter = new JsonRPFormatter(out);){
            JsonShowResourcePlanFormatter.formatFullRP(formatter, resourcePlan);
        }
        catch (IOException e) {
            throw new HiveException((Throwable)e);
        }
    }

    private static class JsonRPFormatter
    implements ShowResourcePlanFormatter.RPFormatter,
    Closeable {
        private final JsonGenerator generator;

        JsonRPFormatter(DataOutputStream out) throws IOException {
            this.generator = new ObjectMapper().getJsonFactory().createJsonGenerator((OutputStream)out);
        }

        private void writeNameAndFields(String name, Object ... keyValuePairs) throws IOException {
            if (keyValuePairs.length % 2 != 0) {
                throw new IllegalArgumentException("Expected pairs");
            }
            this.generator.writeStringField("name", name);
            for (int i = 0; i < keyValuePairs.length; i += 2) {
                this.generator.writeObjectField(keyValuePairs[i].toString(), keyValuePairs[i + 1]);
            }
        }

        @Override
        public void startRP(String rpName, Object ... keyValuePairs) throws IOException {
            this.generator.writeStartObject();
            this.writeNameAndFields(rpName, keyValuePairs);
        }

        @Override
        public void endRP() throws IOException {
            this.generator.writeEndObject();
        }

        @Override
        public void startPools() throws IOException {
            this.generator.writeArrayFieldStart("pools");
        }

        @Override
        public void endPools() throws IOException {
            this.generator.writeEndArray();
        }

        @Override
        public void startPool(String poolName, Object ... keyValuePairs) throws IOException {
            this.generator.writeStartObject();
            this.writeNameAndFields(poolName, keyValuePairs);
        }

        @Override
        public void startTriggers() throws IOException {
            this.generator.writeArrayFieldStart("triggers");
        }

        @Override
        public void endTriggers() throws IOException {
            this.generator.writeEndArray();
        }

        @Override
        public void startMappings() throws IOException {
            this.generator.writeArrayFieldStart("mappings");
        }

        @Override
        public void endMappings() throws IOException {
            this.generator.writeEndArray();
        }

        @Override
        public void endPool() throws IOException {
            this.generator.writeEndObject();
        }

        @Override
        public void formatTrigger(String triggerName, String actionExpression, String triggerExpression) throws IOException {
            this.generator.writeStartObject();
            this.writeNameAndFields(triggerName, "action", actionExpression, "trigger", triggerExpression);
            this.generator.writeEndObject();
        }

        @Override
        public void formatMappingType(String type, List<String> names) throws IOException {
            this.generator.writeStartObject();
            this.generator.writeStringField("type", type);
            this.generator.writeArrayFieldStart("values");
            for (String name : names) {
                this.generator.writeString(name);
            }
            this.generator.writeEndArray();
            this.generator.writeEndObject();
        }

        @Override
        public void close() throws IOException {
            this.generator.close();
        }
    }
}

