/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.workloadmanagement.resourceplan.create;

import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.workloadmanagement.resourceplan.create.CreateResourcePlanDesc;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={966})
public class CreateResourcePlanAnalyzer
extends BaseSemanticAnalyzer {
    public CreateResourcePlanAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        if (root.getChildCount() == 0) {
            throw new SemanticException("Expected name in CREATE RESOURCE PLAN statement");
        }
        String resourcePlanName = CreateResourcePlanAnalyzer.unescapeIdentifier(root.getChild(0).getText());
        Integer queryParallelism = null;
        String likeName = null;
        boolean ifNotExists = false;
        block5: for (int i = 1; i < root.getChildCount(); ++i) {
            Tree child = root.getChild(i);
            switch (child.getType()) {
                case 1162: {
                    if (queryParallelism == null && likeName == null) {
                        queryParallelism = Integer.parseInt(child.getChild(0).getText());
                        continue block5;
                    }
                    throw new SemanticException("Conflicting create arguments " + root.toStringTree());
                }
                case 1086: {
                    if (queryParallelism == null && likeName == null) {
                        likeName = CreateResourcePlanAnalyzer.unescapeIdentifier(child.getChild(0).getText());
                        continue block5;
                    }
                    throw new SemanticException("Conflicting create arguments " + root.toStringTree());
                }
                case 1055: {
                    ifNotExists = true;
                    continue block5;
                }
                default: {
                    throw new SemanticException("Invalid create arguments " + root.toStringTree());
                }
            }
        }
        CreateResourcePlanDesc desc = new CreateResourcePlanDesc(resourcePlanName, queryParallelism, likeName, ifNotExists);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
        DDLUtils.addServiceOutput(this.conf, this.getOutputs());
    }
}

