/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.view.materialized.show;

import com.google.common.collect.ImmutableMap;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ddl.ShowUtils;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveMaterializedViewsRegistry;
import org.apache.hadoop.hive.ql.metadata.HiveRelOptMaterialization;
import org.apache.hadoop.hive.ql.metadata.RewriteAlgorithm;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.formatting.MetaDataFormatUtils;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.IncrementalRebuildMode;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.jetbrains.annotations.NotNull;

abstract class ShowMaterializedViewsFormatter {
    ShowMaterializedViewsFormatter() {
    }

    static ShowMaterializedViewsFormatter getFormatter(HiveConf conf) {
        if (MetaDataFormatUtils.isJson(conf)) {
            return new JsonShowMaterializedViewsFormatter();
        }
        return new TextShowMaterializedViewsFormatter();
    }

    abstract void showMaterializedViews(DataOutputStream var1, List<Table> var2) throws HiveException;

    private static String getMode(Table materializedView) {
        long time;
        String refreshMode = "Manual refresh";
        String timeWindowString = materializedView.getProperty("rewriting.time.window");
        Object mode = !StringUtils.isEmpty((CharSequence)timeWindowString) ? ((time = HiveConf.toTime((String)timeWindowString, (TimeUnit)HiveConf.getDefaultTimeUnit((HiveConf.ConfVars)HiveConf.ConfVars.HIVE_MATERIALIZED_VIEW_REWRITING_TIME_WINDOW), (TimeUnit)TimeUnit.MINUTES)) > 0L ? refreshMode + " (Valid for " + time + "min)" : (time == 0L ? refreshMode + " (Valid until source tables modified)" : refreshMode + " (Valid always)")) : refreshMode;
        return mode;
    }

    @NotNull
    private static String formatIncrementalRebuildMode(Table materializedView) {
        HiveRelOptMaterialization relOptMaterialization = HiveMaterializedViewsRegistry.get().getRewritingMaterializedView(materializedView.getDbName(), materializedView.getTableName(), RewriteAlgorithm.ALL);
        if (relOptMaterialization == null) {
            return IncrementalRebuildMode.NOT_AVAILABLE.getMessage();
        }
        return relOptMaterialization.getRebuildMode().getMessage();
    }

    static class JsonShowMaterializedViewsFormatter
    extends ShowMaterializedViewsFormatter {
        JsonShowMaterializedViewsFormatter() {
        }

        @Override
        void showMaterializedViews(DataOutputStream out, List<Table> materializedViews) throws HiveException {
            if (materializedViews.isEmpty()) {
                return;
            }
            ArrayList<ImmutableMap> materializedViewDataList = new ArrayList<ImmutableMap>();
            for (Table materializedView : materializedViews) {
                String name = materializedView.getTableName();
                String rewriteEnabled = materializedView.isRewriteEnabled() ? "Yes" : "No";
                String mode = ShowMaterializedViewsFormatter.getMode(materializedView);
                ImmutableMap materializedViewData = ImmutableMap.of((Object)"MV Name", (Object)name, (Object)"Rewriting Enabled", (Object)rewriteEnabled, (Object)"Mode", (Object)mode, (Object)"Incremental rebuild", (Object)ShowMaterializedViewsFormatter.formatIncrementalRebuildMode(materializedView));
                materializedViewDataList.add(materializedViewData);
            }
            ShowUtils.asJson(out, (Map<String, Object>)ImmutableMap.of((Object)"materialized views", materializedViewDataList));
        }
    }

    static class TextShowMaterializedViewsFormatter
    extends ShowMaterializedViewsFormatter {
        TextShowMaterializedViewsFormatter() {
        }

        @Override
        void showMaterializedViews(DataOutputStream out, List<Table> materializedViews) throws HiveException {
            if (materializedViews.isEmpty()) {
                return;
            }
            try {
                ShowUtils.TextMetaDataTable mdt = new ShowUtils.TextMetaDataTable();
                if (!SessionState.get().isHiveServerQuery()) {
                    mdt.addRow("# MV Name", "Rewriting Enabled", "Mode", "Incremental rebuild");
                }
                for (Table materializedView : materializedViews) {
                    String name = materializedView.getTableName();
                    String rewriteEnabled = materializedView.isRewriteEnabled() ? "Yes" : "No";
                    String mode = ShowMaterializedViewsFormatter.getMode(materializedView);
                    String incrementalRebuild = ShowMaterializedViewsFormatter.formatIncrementalRebuildMode(materializedView);
                    mdt.addRow(name, rewriteEnabled, mode, incrementalRebuild);
                }
                out.write(mdt.renderTable(!SessionState.get().isHiveServerQuery()).getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw new HiveException((Throwable)e);
            }
        }
    }
}

