/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.view.create;

import java.util.HashSet;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.SourceTable;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.view.create.CreateMaterializedViewDesc;
import org.apache.hadoop.hive.ql.hooks.LineageInfo;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.MaterializedViewMetadata;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.HiveMaterializedViewUtils;

public class CreateMaterializedViewOperation
extends DDLOperation<CreateMaterializedViewDesc> {
    public CreateMaterializedViewOperation(DDLOperationContext context, CreateMaterializedViewDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        Table oldview = this.context.getDb().getTable(((CreateMaterializedViewDesc)this.desc).getViewName(), false);
        if (oldview != null) {
            if (((CreateMaterializedViewDesc)this.desc).getIfNotExists()) {
                return 0;
            }
            throw new HiveException(ErrorMsg.TABLE_ALREADY_EXISTS.getMsg(((CreateMaterializedViewDesc)this.desc).getViewName()));
        }
        Table tbl = ((CreateMaterializedViewDesc)this.desc).toTable(this.context.getConf());
        if (tbl.isMaterializedView()) {
            HashSet<SourceTable> sourceTables = new HashSet<SourceTable>(((CreateMaterializedViewDesc)this.desc).getTablesUsed().size());
            for (TableName tableName : ((CreateMaterializedViewDesc)this.desc).getTablesUsed()) {
                sourceTables.add(this.context.getDb().getTable(tableName).createSourceTable());
            }
            MaterializedViewMetadata metadata = new MaterializedViewMetadata(MetaStoreUtils.getDefaultCatalog((Configuration)this.context.getConf()), tbl.getDbName(), tbl.getTableName(), sourceTables, HiveMaterializedViewUtils.getSnapshotOf(this.context, ((CreateMaterializedViewDesc)this.desc).getTablesUsed()));
            tbl.setMaterializedViewMetadata(metadata);
        }
        this.context.getDb().createTable(tbl, ((CreateMaterializedViewDesc)this.desc).getIfNotExists());
        DDLUtils.addIfAbsentByName(new WriteEntity(tbl, WriteEntity.WriteType.DDL_NO_LOCK), this.context.getWork().getOutputs());
        LineageInfo.DataContainer dc = new LineageInfo.DataContainer(tbl.getTTable());
        Map tblProps = tbl.getTTable().getParameters();
        Path tlocation = null;
        try {
            Warehouse wh = new Warehouse((Configuration)this.context.getConf());
            tlocation = wh.getDefaultTablePath(this.context.getDb().getDatabase(tbl.getDbName()), tbl.getTableName(), tblProps == null || !AcidUtils.isTablePropertyTransactional(tblProps));
        }
        catch (MetaException e) {
            throw new HiveException((Throwable)e);
        }
        this.context.getQueryState().getLineageState().setLineage(tlocation, dc, tbl.getCols());
        return 0;
    }
}

