/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.storage.skewed;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableOperation;
import org.apache.hadoop.hive.ql.ddl.table.storage.skewed.AlterTableSetSkewedLocationDesc;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;

public class AlterTableSetSkewedLocationOperation
extends AbstractAlterTableOperation<AlterTableSetSkewedLocationDesc> {
    public AlterTableSetSkewedLocationOperation(DDLOperationContext context, AlterTableSetSkewedLocationDesc desc) {
        super(context, desc);
    }

    @Override
    protected void doAlteration(Table table, Partition partition) throws HiveException {
        for (Map.Entry<List<String>, String> entry : ((AlterTableSetSkewedLocationDesc)this.desc).getSkewedLocations().entrySet()) {
            List<String> key = entry.getKey();
            String newLocation = entry.getValue();
            try {
                URI locationUri = new URI(newLocation);
                ArrayList<String> skewedLocation = new ArrayList<String>(key);
                if (partition != null) {
                    partition.setSkewedValueLocationMap(skewedLocation, locationUri.toString());
                    continue;
                }
                table.setSkewedValueLocationMap(skewedLocation, locationUri.toString());
            }
            catch (URISyntaxException e) {
                throw new HiveException((Throwable)e);
            }
        }
        this.environmentContext.getProperties().remove("DO_NOT_UPDATE_STATS");
    }
}

