/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.storage.concatenate;

import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableDesc;
import org.apache.hadoop.hive.ql.ddl.table.AlterTableType;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ListBucketingCtx;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.mapred.InputFormat;

@Explain(displayName="Concatenate", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class AlterTableConcatenateDesc
extends AbstractAlterTableDesc
implements DDLDesc {
    private final String tableName;
    private final Map<String, String> partitionSpec;
    private final ListBucketingCtx lbCtx;
    private final Path inputDir;
    private final Path outputDir;
    private final Class<? extends InputFormat> inputFormatClass;
    private final TableDesc tableDesc;

    public AlterTableConcatenateDesc(TableName tableName, Map<String, String> partitionSpec, ListBucketingCtx lbCtx, Path inputDir, Path outputDir, Class<? extends InputFormat> inputFormatClass, TableDesc tableDesc) throws SemanticException {
        super(AlterTableType.MERGEFILES, tableName, partitionSpec, null, false, false, null);
        this.tableName = tableName.getNotEmptyDbTable();
        this.partitionSpec = partitionSpec;
        this.lbCtx = lbCtx;
        this.inputDir = inputDir;
        this.outputDir = outputDir;
        this.inputFormatClass = inputFormatClass;
        this.tableDesc = tableDesc;
    }

    @Override
    @Explain(displayName="partition spec")
    public Map<String, String> getPartitionSpec() {
        return this.partitionSpec;
    }

    public ListBucketingCtx getLbCtx() {
        return this.lbCtx;
    }

    public Path getInputDir() {
        return this.inputDir;
    }

    public Path getOutputDir() {
        return this.outputDir;
    }

    public Class<? extends InputFormat> getInputFormatClass() {
        return this.inputFormatClass;
    }

    public TableDesc getTableDesc() {
        return this.tableDesc;
    }
}

