/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.storage.archive;

import java.util.List;
import java.util.Map;
import org.antlr.runtime.tree.CommonTree;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableAnalyzer;
import org.apache.hadoop.hive.ql.ddl.table.AlterTableType;
import org.apache.hadoop.hive.ql.ddl.table.partition.PartitionUtils;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.SemanticException;

public abstract class AbstractAlterTableArchiveAnalyzer
extends AbstractAlterTableAnalyzer {
    public AbstractAlterTableArchiveAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    protected void analyzeCommand(TableName tableName, Map<String, String> partSpec, ASTNode command) throws SemanticException {
        if (!this.conf.getBoolVar(HiveConf.ConfVars.HIVE_ARCHIVE_ENABLED)) {
            throw new SemanticException(ErrorMsg.ARCHIVE_METHODS_DISABLED.getMsg());
        }
        Table table = this.getTable(tableName);
        this.validateAlterTableType(table, AlterTableType.ARCHIVE, false);
        List<Map<String, String>> partitionSpecs = this.getPartitionSpecs(table, (CommonTree)command);
        if (partitionSpecs.size() > 1) {
            throw new SemanticException(this.getMultiPartsErrorMessage().getMsg());
        }
        if (partitionSpecs.size() == 0) {
            throw new SemanticException(ErrorMsg.ARCHIVE_ON_TABLE.getMsg());
        }
        Map<String, String> partitionSpec = partitionSpecs.get(0);
        try {
            this.isValidPrefixSpec(table, partitionSpec);
        }
        catch (HiveException e) {
            throw new SemanticException(e.getMessage(), (Throwable)e);
        }
        this.inputs.add(new ReadEntity(table));
        PartitionUtils.addTablePartsOutputs(this.db, this.outputs, table, partitionSpecs, true, WriteEntity.WriteType.DDL_NO_LOCK);
        DDLDesc archiveDesc = this.createDesc(tableName, partitionSpec);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), archiveDesc)));
    }

    protected abstract ErrorMsg getMultiPartsErrorMessage();

    protected abstract DDLDesc createDesc(TableName var1, Map<String, String> var2);
}

