/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.misc.properties;

import java.util.Map;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableDesc;
import org.apache.hadoop.hive.ql.ddl.table.misc.properties.AbstractAlterTablePropertiesAnalyzer;
import org.apache.hadoop.hive.ql.ddl.table.misc.properties.AlterTableUnsetPropertiesDesc;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.SemanticException;

public abstract class AbstractAlterTableUnsetPropertiesAnalyzer
extends AbstractAlterTablePropertiesAnalyzer {
    public AbstractAlterTableUnsetPropertiesAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    protected AbstractAlterTableDesc createDesc(ASTNode command, TableName tableName, Map<String, String> partitionSpec, Map<String, String> properties, boolean isToTxn, boolean isExplicitStatsUpdate, EnvironmentContext environmentContext) throws SemanticException {
        boolean dropIfExists;
        boolean bl = dropIfExists = command.getChild(1) != null;
        if (!dropIfExists) {
            Table table = this.getTable(tableName, true);
            Map tableParams = table.getTTable().getParameters();
            for (String key : properties.keySet()) {
                if (tableParams.containsKey(key)) continue;
                String errorMsg = "The following property " + key + " does not exist in " + table.getTableName();
                throw new SemanticException(ErrorMsg.ALTER_TBL_UNSET_NON_EXIST_PROPERTY.getMsg(errorMsg));
            }
        }
        return new AlterTableUnsetPropertiesDesc(tableName, partitionSpec, null, this.isView(), properties, isExplicitStatsUpdate, environmentContext);
    }

    @Override
    protected abstract boolean isView();
}

