/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.column.drop;

import java.util.ArrayList;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableOperation;
import org.apache.hadoop.hive.ql.ddl.table.AlterTableUtils;
import org.apache.hadoop.hive.ql.ddl.table.column.drop.AlterTableDropColumnDesc;
import org.apache.hadoop.hive.ql.io.orc.OrcSerde;
import org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeUtils;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;

public class AlterTableDropColumnOperation
extends AbstractAlterTableOperation<AlterTableDropColumnDesc> {
    public AlterTableDropColumnOperation(DDLOperationContext context, AlterTableDropColumnDesc desc) {
        super(context, desc);
    }

    @Override
    protected void doAlteration(Table table, Partition partition) throws HiveException {
        boolean isOrcSchemaEvolution;
        StorageDescriptor sd = this.getStorageDescriptor(table, partition);
        String serializationLib = sd.getSerdeInfo().getSerializationLib();
        AvroSerdeUtils.handleAlterTableForAvro((HiveConf)this.context.getConf(), (String)serializationLib, (Map)table.getTTable().getParameters());
        if ("org.apache.hadoop.hive.serde.thrift.columnsetSerDe".equals(serializationLib)) {
            this.context.getConsole().printInfo("Dropping column for columnsetSerDe and changing to LazySimpleSerDe");
            sd.getSerdeInfo().setSerializationLib(LazySimpleSerDe.class.getName());
        }
        boolean bl = isOrcSchemaEvolution = serializationLib.equals(OrcSerde.class.getName()) && AlterTableUtils.isSchemaEvolutionEnabled(table, (Configuration)this.context.getConf());
        if (isOrcSchemaEvolution) {
            throw new HiveException(ErrorMsg.CANNOT_DROP_COLUMN, new String[]{((AlterTableDropColumnDesc)this.desc).getDbTableName()});
        }
        if (ParquetHiveSerDe.isParquetTable(table) && AlterTableUtils.isSchemaEvolutionEnabled(table, (Configuration)this.context.getConf()) && !((AlterTableDropColumnDesc)this.desc).isCascade() && table.isPartitioned()) {
            LOG.warn("Cannot drop column from a partitioned parquet table without the CASCADE option");
            throw new HiveException(ErrorMsg.DROP_COLUMN_UNCASCADED, new String[]{((AlterTableDropColumnDesc)this.desc).getDbTableName()});
        }
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>(sd.getCols());
        boolean removed = cols.removeIf(col -> col.getName().equalsIgnoreCase(((AlterTableDropColumnDesc)this.desc).getColName()));
        if (!removed) {
            if (((AlterTableDropColumnDesc)this.desc).isIfExists()) {
                return;
            }
            throw new HiveException(ErrorMsg.INVALID_COLUMN_NAME, new String[]{((AlterTableDropColumnDesc)this.desc).getColName()});
        }
        sd.setCols(cols);
    }
}

