/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.function.drop;

import java.util.Map;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.function.drop.DropFunctionDesc;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.FunctionUtils;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.util.StringUtils;

public class DropFunctionOperation
extends DDLOperation<DropFunctionDesc> {
    public DropFunctionOperation(DDLOperationContext context, DropFunctionDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        if (((DropFunctionDesc)this.desc).isTemporary()) {
            return this.dropTemporaryFunction();
        }
        try {
            return this.dropPermanentFunction();
        }
        catch (Exception e) {
            this.context.getTask().setException(e);
            LOG.error("Failed to drop function", (Throwable)e);
            return 1;
        }
    }

    private int dropTemporaryFunction() {
        try {
            FunctionRegistry.unregisterTemporaryUDF(((DropFunctionDesc)this.desc).getName());
            return 0;
        }
        catch (HiveException e) {
            LOG.info("drop function: ", (Throwable)e);
            return 1;
        }
    }

    private int dropPermanentFunction() throws HiveException {
        String functionName;
        String[] qualifiedNameParts = FunctionUtils.getQualifiedFunctionNameParts(((DropFunctionDesc)this.desc).getName());
        String dbName = qualifiedNameParts[0];
        if (this.skipIfNewerThenUpdate(dbName, functionName = qualifiedNameParts[1])) {
            return 0;
        }
        try {
            String registeredName = FunctionUtils.qualifyFunctionName(functionName, dbName);
            FunctionRegistry.unregisterPermanentFunction(registeredName);
            this.context.getDb().dropFunction(dbName, functionName);
            return 0;
        }
        catch (Exception e) {
            if (((DropFunctionDesc)this.desc).getReplicationSpec().isInReplicationScope() && e.getCause() instanceof NoSuchObjectException) {
                LOG.info("Drop function is idempotent as function: " + ((DropFunctionDesc)this.desc).getName() + " doesn't exist.");
                return 0;
            }
            LOG.info("drop function: ", (Throwable)e);
            this.context.getConsole().printError("FAILED: error during drop function: " + StringUtils.stringifyException((Throwable)e));
            return 1;
        }
    }

    private boolean skipIfNewerThenUpdate(String dbName, String functionName) throws HiveException {
        if (((DropFunctionDesc)this.desc).getReplicationSpec().isInReplicationScope()) {
            Map dbProps = Hive.get().getDatabase(dbName).getParameters();
            if (!((DropFunctionDesc)this.desc).getReplicationSpec().allowEventReplacementInto(dbProps)) {
                LOG.debug("FunctionTask: Drop Function {} is skipped as database {} is newer than update", (Object)functionName, (Object)dbName);
                return true;
            }
        }
        return false;
    }
}

