/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.database.drop;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.llap.LlapHiveUtils;
import org.apache.hadoop.hive.llap.ProactiveEviction;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.database.drop.DropDatabaseDesc;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;

public class DropDatabaseOperation
extends DDLOperation<DropDatabaseDesc> {
    public DropDatabaseOperation(DDLOperationContext context, DropDatabaseDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        try {
            Database database;
            String dbName = ((DropDatabaseDesc)this.desc).getDatabaseName();
            ReplicationSpec replicationSpec = ((DropDatabaseDesc)this.desc).getReplicationSpec();
            if (replicationSpec.isInReplicationScope() && ((database = this.context.getDb().getDatabase(dbName)) == null || !replicationSpec.allowEventReplacementInto(database.getParameters()))) {
                return 0;
            }
            this.context.getDb().dropDatabase((DropDatabaseDesc)this.desc);
            if (LlapHiveUtils.isLlapMode((Configuration)this.context.getConf())) {
                ProactiveEviction.Request.Builder llapEvictRequestBuilder = ProactiveEviction.Request.Builder.create();
                llapEvictRequestBuilder.addDb(dbName);
                ProactiveEviction.evict((Configuration)this.context.getConf(), llapEvictRequestBuilder.build());
            }
            if (((DropDatabaseDesc)this.desc).isCasdade()) {
                FunctionRegistry.unregisterPermanentFunctions(dbName);
            }
        }
        catch (NoSuchObjectException ex) {
            throw new HiveException((Throwable)ex, ErrorMsg.DATABASE_NOT_EXISTS, new String[]{((DropDatabaseDesc)this.desc).getDatabaseName()});
        }
        return 0;
    }
}

