/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.database.desc;

import java.io.DataOutputStream;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.ShowUtils;
import org.apache.hadoop.hive.ql.ddl.database.desc.DescDatabaseDesc;
import org.apache.hadoop.hive.ql.ddl.database.desc.DescDatabaseFormatter;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class DescDatabaseOperation
extends DDLOperation<DescDatabaseDesc> {
    public DescDatabaseOperation(DDLOperationContext context, DescDatabaseDesc desc) {
        super(context, desc);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int execute() throws HiveException {
        try (DataOutputStream outStream = ShowUtils.getOutputStream(new Path(((DescDatabaseDesc)this.desc).getResFile()), this.context);){
            Database database = this.context.getDb().getDatabase(((DescDatabaseDesc)this.desc).getDatabaseName());
            if (database == null) {
                throw new HiveException(ErrorMsg.DATABASE_NOT_EXISTS, new String[]{((DescDatabaseDesc)this.desc).getDatabaseName()});
            }
            TreeMap<String, String> params = null;
            String location = "";
            if (((DescDatabaseDesc)this.desc).isExtended()) {
                params = new TreeMap<String, String>(database.getParameters());
            }
            DescDatabaseFormatter formatter = DescDatabaseFormatter.getFormatter(this.context.getConf());
            switch (database.getType()) {
                case NATIVE: {
                    location = database.getLocationUri();
                    if (HiveConf.getBoolVar((Configuration)this.context.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_IN_TEST)) {
                        location = "location/in/test";
                    }
                    formatter.showDatabaseDescription(outStream, database.getName(), database.getDescription(), location, database.getManagedLocationUri(), database.getOwnerName(), database.getOwnerType(), params, "", "");
                    return 0;
                }
                case REMOTE: {
                    formatter.showDatabaseDescription(outStream, database.getName(), database.getDescription(), "", "", database.getOwnerName(), database.getOwnerType(), params, database.getConnector_name(), database.getRemote_dbname());
                    return 0;
                }
                default: {
                    throw new HiveException("Unsupported database type " + String.valueOf(database.getType()) + " for " + database.getName());
                }
            }
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e, ErrorMsg.GENERIC_ERROR);
        }
    }
}

