/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazybinary.fast;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import org.apache.hadoop.hive.common.type.DataTypePhysicalVariation;
import org.apache.hadoop.hive.serde2.fast.DeserializeRead;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;
import org.apache.hadoop.io.WritableUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LazyBinaryDeserializeRead
extends DeserializeRead {
    public static final Logger LOG = LoggerFactory.getLogger((String)LazyBinaryDeserializeRead.class.getName());
    private byte[] bytes;
    private int start;
    private int offset;
    private int end;
    private boolean skipLengthPrefix = false;
    private LazyBinaryUtils.VInt tempVInt;
    private LazyBinaryUtils.VLong tempVLong;
    private Deque<Field> stack = new ArrayDeque<Field>();
    private Field root;

    public LazyBinaryDeserializeRead(TypeInfo[] typeInfos, boolean useExternalBuffer) {
        this(typeInfos, null, useExternalBuffer);
    }

    public LazyBinaryDeserializeRead(TypeInfo[] typeInfos, DataTypePhysicalVariation[] dataTypePhysicalVariations, boolean useExternalBuffer) {
        super(typeInfos, dataTypePhysicalVariations, useExternalBuffer);
        this.tempVInt = new LazyBinaryUtils.VInt();
        this.tempVLong = new LazyBinaryUtils.VLong();
        this.currentExternalBufferNeeded = false;
        this.root = new Field(this);
        this.root.category = ObjectInspector.Category.STRUCT;
        this.root.children = this.createFields(typeInfos);
        this.root.count = typeInfos.length;
    }

    private Field[] createFields(TypeInfo[] typeInfos) {
        Field[] children = new Field[typeInfos.length];
        for (int i = 0; i < typeInfos.length; ++i) {
            children[i] = this.createField(typeInfos[i]);
        }
        return children;
    }

    private Field createField(TypeInfo typeInfo) {
        ObjectInspector.Category category;
        Field field = new Field(this);
        field.category = category = typeInfo.getCategory();
        field.typeInfo = typeInfo;
        switch (category) {
            case PRIMITIVE: {
                field.primitiveCategory = ((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory();
                break;
            }
            case LIST: {
                field.children = new Field[1];
                field.children[0] = this.createField(((ListTypeInfo)typeInfo).getListElementTypeInfo());
                break;
            }
            case MAP: {
                field.children = new Field[2];
                field.children[0] = this.createField(((MapTypeInfo)typeInfo).getMapKeyTypeInfo());
                field.children[1] = this.createField(((MapTypeInfo)typeInfo).getMapValueTypeInfo());
                break;
            }
            case STRUCT: {
                StructTypeInfo structTypeInfo = (StructTypeInfo)typeInfo;
                List<TypeInfo> fieldTypeInfos = structTypeInfo.getAllStructFieldTypeInfos();
                field.children = this.createFields(fieldTypeInfos.toArray(new TypeInfo[fieldTypeInfos.size()]));
                break;
            }
            case UNION: {
                UnionTypeInfo unionTypeInfo = (UnionTypeInfo)typeInfo;
                List<TypeInfo> objectTypeInfos = unionTypeInfo.getAllUnionObjectTypeInfos();
                field.children = this.createFields(objectTypeInfos.toArray(new TypeInfo[objectTypeInfos.size()]));
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        return field;
    }

    @Override
    public void set(byte[] bytes, int offset, int length) {
        this.bytes = bytes;
        this.offset = offset;
        this.start = offset;
        this.end = offset + length;
        this.stack.clear();
        this.stack.push(this.root);
        this.clearIndex(this.root);
    }

    private void clearIndex(Field field) {
        field.index = 0;
        if (field.children == null) {
            return;
        }
        for (Field child : field.children) {
            this.clearIndex(child);
        }
    }

    @Override
    public String getDetailedReadPositionString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("Reading byte[] of length ");
        sb.append(this.bytes.length);
        sb.append(" at start offset ");
        sb.append(this.start);
        sb.append(" for length ");
        sb.append(this.end - this.start);
        sb.append(" to read ");
        sb.append(this.root.children.length);
        sb.append(" fields with types ");
        sb.append(Arrays.toString(this.typeInfos));
        sb.append(".  Read field #");
        sb.append(this.root.index);
        sb.append(" at field start position ");
        sb.append(this.root.start);
        sb.append(" current read offset ");
        sb.append(this.offset);
        return sb.toString();
    }

    @Override
    public boolean readNextField() throws IOException {
        return this.readComplexField();
    }

    private boolean readPrimitive(Field field) throws IOException {
        PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = field.primitiveCategory;
        TypeInfo typeInfo = field.typeInfo;
        switch (primitiveCategory) {
            case BOOLEAN: {
                this.currentBoolean = this.bytes[this.offset++] != 0;
                break;
            }
            case BYTE: {
                this.currentByte = this.bytes[this.offset++];
                break;
            }
            case SHORT: {
                if (this.offset + 2 > this.end) {
                    throw new EOFException();
                }
                this.currentShort = LazyBinaryUtils.byteArrayToShort(this.bytes, this.offset);
                this.offset += 2;
                break;
            }
            case INT: {
                if (this.offset + WritableUtils.decodeVIntSize((byte)this.bytes[this.offset]) > this.end) {
                    throw new EOFException();
                }
                LazyBinaryUtils.readVInt(this.bytes, this.offset, this.tempVInt);
                this.offset += this.tempVInt.length;
                this.currentInt = this.tempVInt.value;
                break;
            }
            case LONG: {
                if (this.offset + WritableUtils.decodeVIntSize((byte)this.bytes[this.offset]) > this.end) {
                    throw new EOFException();
                }
                LazyBinaryUtils.readVLong(this.bytes, this.offset, this.tempVLong);
                this.offset += this.tempVLong.length;
                this.currentLong = this.tempVLong.value;
                break;
            }
            case FLOAT: {
                if (this.offset + 4 > this.end) {
                    throw new EOFException();
                }
                this.currentFloat = Float.intBitsToFloat(LazyBinaryUtils.byteArrayToInt(this.bytes, this.offset));
                this.offset += 4;
                break;
            }
            case DOUBLE: {
                if (this.offset + 8 > this.end) {
                    throw new EOFException();
                }
                this.currentDouble = Double.longBitsToDouble(LazyBinaryUtils.byteArrayToLong(this.bytes, this.offset));
                this.offset += 8;
                break;
            }
            case BINARY: 
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                if (this.offset + WritableUtils.decodeVIntSize((byte)this.bytes[this.offset]) > this.end) {
                    throw new EOFException();
                }
                LazyBinaryUtils.readVInt(this.bytes, this.offset, this.tempVInt);
                this.offset += this.tempVInt.length;
                int saveStart = this.offset;
                int length = this.tempVInt.value;
                this.offset += length;
                if (this.offset > this.end) {
                    throw new EOFException();
                }
                this.currentBytes = this.bytes;
                this.currentBytesStart = saveStart;
                this.currentBytesLength = length;
                break;
            }
            case DATE: {
                if (this.offset + WritableUtils.decodeVIntSize((byte)this.bytes[this.offset]) > this.end) {
                    throw new EOFException();
                }
                LazyBinaryUtils.readVInt(this.bytes, this.offset, this.tempVInt);
                this.offset += this.tempVInt.length;
                this.currentDateWritable.set(this.tempVInt.value);
                break;
            }
            case TIMESTAMP: {
                int length = TimestampWritableV2.getTotalLength(this.bytes, this.offset);
                int saveStart = this.offset;
                this.offset += length;
                if (this.offset > this.end) {
                    throw new EOFException();
                }
                this.currentTimestampWritable.set(this.bytes, saveStart);
                break;
            }
            case INTERVAL_YEAR_MONTH: {
                if (this.offset + WritableUtils.decodeVIntSize((byte)this.bytes[this.offset]) > this.end) {
                    throw new EOFException();
                }
                LazyBinaryUtils.readVInt(this.bytes, this.offset, this.tempVInt);
                this.offset += this.tempVInt.length;
                this.currentHiveIntervalYearMonthWritable.set(this.tempVInt.value);
                break;
            }
            case INTERVAL_DAY_TIME: {
                if (this.offset + WritableUtils.decodeVIntSize((byte)this.bytes[this.offset]) >= this.end) {
                    throw new EOFException();
                }
                LazyBinaryUtils.readVLong(this.bytes, this.offset, this.tempVLong);
                this.offset += this.tempVLong.length;
                if (this.offset + WritableUtils.decodeVIntSize((byte)this.bytes[this.offset]) > this.end) {
                    throw new EOFException();
                }
                LazyBinaryUtils.readVInt(this.bytes, this.offset, this.tempVInt);
                this.offset += this.tempVInt.length;
                this.currentHiveIntervalDayTimeWritable.set(this.tempVLong.value, this.tempVInt.value);
                break;
            }
            case DECIMAL: {
                boolean decimalIsNull;
                if (this.offset + WritableUtils.decodeVIntSize((byte)this.bytes[this.offset]) >= this.end) {
                    throw new EOFException();
                }
                LazyBinaryUtils.readVInt(this.bytes, this.offset, this.tempVInt);
                this.offset += this.tempVInt.length;
                int readScale = this.tempVInt.value;
                if (this.offset + WritableUtils.decodeVIntSize((byte)this.bytes[this.offset]) > this.end) {
                    throw new EOFException();
                }
                LazyBinaryUtils.readVInt(this.bytes, this.offset, this.tempVInt);
                this.offset += this.tempVInt.length;
                int saveStart = this.offset;
                this.offset += this.tempVInt.value;
                if (this.offset > this.end) {
                    throw new EOFException();
                }
                int length = this.offset - saveStart;
                this.currentHiveDecimalWritable.setFromBigIntegerBytesAndScale(this.bytes, saveStart, length, readScale);
                boolean bl = decimalIsNull = !this.currentHiveDecimalWritable.isSet();
                if (!decimalIsNull) {
                    int scale;
                    DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)typeInfo;
                    int precision = decimalTypeInfo.getPrecision();
                    boolean bl2 = decimalIsNull = !this.currentHiveDecimalWritable.mutateEnforcePrecisionScale(precision, scale = decimalTypeInfo.getScale());
                    if (!decimalIsNull) {
                        return true;
                    }
                }
                return false;
            }
            default: {
                throw new Error("Unexpected primitive category " + primitiveCategory.name());
            }
        }
        return true;
    }

    @Override
    public void skipNextField() throws IOException {
        Field current = this.stack.peek();
        boolean isNull = this.isNull(current);
        if (isNull) {
            ++current.index;
            return;
        }
        if (this.readUnionTag(current)) {
            ++current.index;
            return;
        }
        Field child = this.getChild(current);
        if (child.category == ObjectInspector.Category.PRIMITIVE) {
            this.readPrimitive(child);
            ++current.index;
        } else {
            this.parseHeader(child);
            this.stack.push(child);
            for (int i = 0; i < child.count; ++i) {
                this.skipNextField();
            }
            this.finishComplexVariableFieldsType();
        }
        if (this.offset > this.end) {
            throw new EOFException();
        }
    }

    @Override
    public boolean isEndOfInputReached() {
        return this.offset == this.end;
    }

    private boolean isNull(Field field) {
        byte b = (byte)(1 << field.index % 8);
        switch (field.category) {
            case PRIMITIVE: {
                return false;
            }
            case LIST: 
            case MAP: {
                byte nullByte = this.bytes[field.nullByteStart + field.index / 8];
                return (nullByte & b) == 0;
            }
            case STRUCT: {
                if (field.index % 8 == 0) {
                    field.nullByte = this.bytes[this.offset++];
                }
                return (field.nullByte & b) == 0;
            }
            case UNION: {
                return false;
            }
        }
        throw new RuntimeException();
    }

    private void parseHeader(Field field) {
        field.index = 0;
        field.start = this.offset;
        if (!this.skipLengthPrefix) {
            int length = LazyBinaryUtils.byteArrayToInt(this.bytes, this.offset);
            this.offset += 4;
            field.end = this.offset + length;
        }
        switch (field.category) {
            case LIST: 
            case MAP: {
                LazyBinaryUtils.readVInt(this.bytes, this.offset, this.tempVInt);
                field.count = field.category == ObjectInspector.Category.LIST ? this.tempVInt.value : this.tempVInt.value * 2;
                this.offset += this.tempVInt.length;
                field.nullByteStart = this.offset;
                this.offset += (field.count + 7) / 8;
                break;
            }
            case STRUCT: {
                field.count = ((StructTypeInfo)field.typeInfo).getAllStructFieldTypeInfos().size();
                break;
            }
            case UNION: {
                field.count = 2;
            }
        }
    }

    private Field getChild(Field field) {
        switch (field.category) {
            case LIST: {
                return field.children[0];
            }
            case MAP: {
                return field.children[field.index % 2];
            }
            case STRUCT: {
                return field.children[field.index];
            }
            case UNION: {
                return field.children[field.tag];
            }
        }
        throw new RuntimeException();
    }

    private boolean readUnionTag(Field field) {
        if (field.category == ObjectInspector.Category.UNION && field.index == 0) {
            field.tag = this.bytes[this.offset++];
            this.currentInt = field.tag;
            return true;
        }
        return false;
    }

    @Override
    public boolean readComplexField() throws IOException {
        Field current = this.stack.peek();
        boolean isNull = this.isNull(current);
        if (isNull) {
            ++current.index;
            return false;
        }
        if (this.readUnionTag(current)) {
            ++current.index;
            return true;
        }
        Field child = this.getChild(current);
        if (child.category == ObjectInspector.Category.PRIMITIVE) {
            isNull = !this.readPrimitive(child);
            ++current.index;
        } else {
            this.parseHeader(child);
            this.stack.push(child);
        }
        if (this.offset > this.end) {
            throw new EOFException();
        }
        return !isNull;
    }

    @Override
    public boolean isNextComplexMultiValue() {
        boolean isNext;
        Field current = this.stack.peek();
        boolean bl = isNext = current.index < current.count;
        if (!isNext) {
            this.stack.pop();
            ++this.stack.peek().index;
        }
        return isNext;
    }

    @Override
    public void finishComplexVariableFieldsType() {
        this.stack.pop();
        if (this.stack.peek() == null) {
            throw new RuntimeException();
        }
        ++this.stack.peek().index;
    }

    private class Field {
        Field[] children;
        ObjectInspector.Category category;
        PrimitiveObjectInspector.PrimitiveCategory primitiveCategory;
        TypeInfo typeInfo;
        DataTypePhysicalVariation dataTypePhysicalVariation;
        int index;
        int count;
        int start;
        int end;
        int nullByteStart;
        byte nullByte;
        byte tag;

        private Field(LazyBinaryDeserializeRead lazyBinaryDeserializeRead) {
        }
    }
}

