/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.datasource;

import com.codahale.metrics.MetricRegistry;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import javax.sql.DataSource;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.datasource.DataSourceProvider;
import org.apache.hadoop.hive.metastore.metrics.Metrics;
import org.apache.hadoop.hive.metastore.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HikariCPDataSourceProvider
implements DataSourceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(HikariCPDataSourceProvider.class);
    static final String HIKARI = "hikaricp";

    @Override
    public DataSource create(Configuration hdpConfig, int maxPoolSize) throws SQLException {
        DatabaseProduct dbProduct;
        String s;
        HikariConfig config;
        String poolName = DataSourceProvider.getDataSourceName(hdpConfig);
        LOG.info("Creating Hikari connection pool for the MetaStore, maxPoolSize: {}, name: {}", (Object)maxPoolSize, (Object)poolName);
        String driverUrl = DataSourceProvider.getMetastoreJdbcDriverUrl(hdpConfig);
        String user = DataSourceProvider.getMetastoreJdbcUser(hdpConfig);
        String passwd = DataSourceProvider.getMetastoreJdbcPasswd(hdpConfig);
        Properties properties = this.replacePrefix(DataSourceProvider.getPrefixedProperties(hdpConfig, HIKARI));
        try {
            config = new HikariConfig(properties);
        }
        catch (Exception e) {
            throw new SQLException("Cannot create HikariCP configuration: ", e);
        }
        config.setMaximumPoolSize(maxPoolSize);
        config.setJdbcUrl(driverUrl);
        config.setUsername(user);
        config.setPassword(passwd);
        if (!StringUtils.isEmpty((CharSequence)poolName)) {
            config.setPoolName(poolName);
        }
        if ("mutex".equals(poolName)) {
            int minimumIdle = Integer.parseInt(hdpConfig.get("hikaricp.minimumIdle", "2"));
            config.setMinimumIdle(Math.min(maxPoolSize, minimumIdle));
        }
        if ((s = (dbProduct = DatabaseProduct.determineDatabaseProduct(driverUrl, hdpConfig)).getPrepareTxnStmt()) != null) {
            config.setConnectionInitSql(s);
        }
        Map<String, String> props = dbProduct.getDataSourceProperties();
        for (Map.Entry<String, String> kv : props.entrySet()) {
            config.addDataSourceProperty(kv.getKey(), (Object)kv.getValue());
        }
        return new HikariDataSource(HikariCPDataSourceProvider.initMetrics(config));
    }

    @Override
    public String getPoolingType() {
        return HIKARI;
    }

    private Properties replacePrefix(Properties props) {
        Properties newProps = new Properties();
        props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> newProps.put(key.toString().replaceFirst("hikaricp.", ""), value)));
        return newProps;
    }

    private static HikariConfig initMetrics(HikariConfig config) {
        MetricRegistry registry = Metrics.getRegistry();
        if (registry != null) {
            config.setMetricRegistry((Object)registry);
        }
        return config;
    }
}

