/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.tezplugins.scheduler;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class StatsPerDag {
    private AtomicInteger numRequestedAllocations = new AtomicInteger(0);
    private AtomicInteger numRequestsWithLocation = new AtomicInteger(0);
    private AtomicInteger numRequestsWithoutLocation = new AtomicInteger(0);
    private int numTotalAllocations = 0;
    private int numLocalAllocations = 0;
    private int numNonLocalAllocations = 0;
    private int numAllocationsNoLocalityRequest = 0;
    private int numRejectedTasks = 0;
    private int numCommFailures = 0;
    private int numDelayedAllocations = 0;
    private int numPreemptedTasks = 0;
    private Map<String, AtomicInteger> localityBasedNumAllocationsPerHost = new HashMap<String, AtomicInteger>();
    private Map<String, AtomicInteger> numAllocationsPerHost = new HashMap<String, AtomicInteger>();

    public int getNumTotalAllocations() {
        return this.numTotalAllocations;
    }

    public int getNumLocalAllocations() {
        return this.numLocalAllocations;
    }

    public int getNumNonLocalAllocations() {
        return this.numNonLocalAllocations;
    }

    public int getNumAllocationsNoLocalityRequest() {
        return this.numAllocationsNoLocalityRequest;
    }

    public int getNumPreemptedTasks() {
        return this.numPreemptedTasks;
    }

    public int getNumRejectedTasks() {
        return this.numRejectedTasks;
    }

    public int getNumDelayedAllocations() {
        return this.numDelayedAllocations;
    }

    public Map<String, AtomicInteger> getNumAllocationsPerHost() {
        return this.numAllocationsPerHost;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("NumPreemptedTasks=").append(this.numPreemptedTasks).append(", ");
        sb.append("NumRequestedAllocations=").append(this.numRequestedAllocations).append(", ");
        sb.append("NumRequestsWithlocation=").append(this.numRequestsWithLocation).append(", ");
        sb.append("NumLocalAllocations=").append(this.numLocalAllocations).append(",");
        sb.append("NumNonLocalAllocations=").append(this.numNonLocalAllocations).append(",");
        sb.append("NumTotalAllocations=").append(this.numTotalAllocations).append(",");
        sb.append("NumRequestsWithoutLocation=").append(this.numRequestsWithoutLocation).append(", ");
        sb.append("NumRejectedTasks=").append(this.numRejectedTasks).append(", ");
        sb.append("NumCommFailures=").append(this.numCommFailures).append(", ");
        sb.append("NumDelayedAllocations=").append(this.numDelayedAllocations).append(", ");
        sb.append("LocalityBasedAllocationsPerHost=").append(this.localityBasedNumAllocationsPerHost).append(", ");
        sb.append("NumAllocationsPerHost=").append(this.numAllocationsPerHost);
        return sb.toString();
    }

    public void registerTaskRequest(String[] requestedHosts, String[] requestedRacks) {
        this.numRequestedAllocations.incrementAndGet();
        if (requestedHosts != null && requestedHosts.length != 0) {
            this.numRequestsWithLocation.incrementAndGet();
        } else {
            this.numRequestsWithoutLocation.incrementAndGet();
        }
    }

    public void registerTaskAllocated(String[] requestedHosts, String[] requestedRacks, String allocatedHost) {
        if (requestedHosts != null && requestedHosts.length != 0) {
            HashSet<String> requestedHostSet = new HashSet<String>(Arrays.asList(requestedHosts));
            if (requestedHostSet.contains(allocatedHost)) {
                ++this.numLocalAllocations;
                this._registerAllocationInHostMap(allocatedHost, this.localityBasedNumAllocationsPerHost);
            } else {
                ++this.numNonLocalAllocations;
            }
        } else {
            ++this.numAllocationsNoLocalityRequest;
        }
        ++this.numTotalAllocations;
        this._registerAllocationInHostMap(allocatedHost, this.numAllocationsPerHost);
    }

    public void registerTaskPreempted(String host) {
        ++this.numPreemptedTasks;
    }

    public void registerCommFailure(String host) {
        ++this.numCommFailures;
    }

    public void registerTaskRejected(String host) {
        ++this.numRejectedTasks;
    }

    public void registerDelayedAllocation() {
        ++this.numDelayedAllocations;
    }

    private void _registerAllocationInHostMap(String host, Map<String, AtomicInteger> hostMap) {
        AtomicInteger val = hostMap.get(host);
        if (val == null) {
            val = new AtomicInteger(0);
            hostMap.put(host, val);
        }
        val.incrementAndGet();
    }
}

