/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.common.DynMethods;
import org.apache.iceberg.hive.CatalogUtils;
import org.apache.iceberg.hive.HMSTablePropertyHelper;
import org.apache.iceberg.hive.HiveSchemaUtil;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.thrift.TException;

public class MetastoreUtil {
    public static final String DEFAULT_INPUT_FORMAT_CLASS = "org.apache.iceberg.mr.hive.HiveIcebergInputFormat";
    public static final String DEFAULT_OUTPUT_FORMAT_CLASS = "org.apache.iceberg.mr.hive.HiveIcebergOutputFormat";
    public static final String DEFAULT_SERDE_CLASS = "org.apache.iceberg.mr.hive.HiveIcebergSerDe";
    private static final DynMethods.UnboundMethod ALTER_TABLE = DynMethods.builder((String)"alter_table").impl(IMetaStoreClient.class, "alter_table_with_environmentContext", new Class[]{String.class, String.class, org.apache.hadoop.hive.metastore.api.Table.class, EnvironmentContext.class}).impl(IMetaStoreClient.class, "alter_table", new Class[]{String.class, String.class, org.apache.hadoop.hive.metastore.api.Table.class, EnvironmentContext.class}).impl(IMetaStoreClient.class, "alter_table", new Class[]{String.class, String.class, org.apache.hadoop.hive.metastore.api.Table.class}).build();

    private MetastoreUtil() {
    }

    public static void alterTable(IMetaStoreClient client, String databaseName, String tblName, org.apache.hadoop.hive.metastore.api.Table table) throws TException {
        MetastoreUtil.alterTable(client, databaseName, tblName, table, (Map<String, String>)ImmutableMap.of());
    }

    public static void alterTable(IMetaStoreClient client, String databaseName, String tblName, org.apache.hadoop.hive.metastore.api.Table table, Map<String, String> extraEnv) throws TException {
        HashMap env = Maps.newHashMapWithExpectedSize((int)(extraEnv.size() + 1));
        env.putAll(extraEnv);
        env.put("DO_NOT_UPDATE_STATS", "true");
        try {
            ALTER_TABLE.invoke((Object)client, new Object[]{databaseName, tblName, table, new EnvironmentContext((Map)env)});
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof TException) {
                throw (TException)e.getCause();
            }
            throw e;
        }
    }

    public static List<FieldSchema> getPartitionKeys(Table table, int specId) {
        Schema schema = ((PartitionSpec)table.specs().get(specId)).schema();
        List<FieldSchema> hiveSchema = HiveSchemaUtil.convert(schema);
        Map<String, String> colNameToColType = hiveSchema.stream().collect(Collectors.toMap(FieldSchema::getName, FieldSchema::getType));
        return ((PartitionSpec)table.specs().get(specId)).fields().stream().map(partField -> new FieldSchema(schema.findColumnName(partField.sourceId()), (String)colNameToColType.get(schema.findColumnName(partField.sourceId())), String.format("Transform: %s", partField.transform().toString()))).toList();
    }

    public static org.apache.hadoop.hive.metastore.api.Table toHiveTable(Table table, Configuration conf) {
        org.apache.hadoop.hive.metastore.api.Table result = new org.apache.hadoop.hive.metastore.api.Table();
        TableName tableName = TableName.fromString((String)table.name(), (String)MetaStoreUtils.getDefaultCatalog((Configuration)conf), (String)"default");
        result.setCatName(tableName.getCat());
        result.setDbName(tableName.getDb());
        result.setTableName(tableName.getTable());
        result.setTableType(TableType.EXTERNAL_TABLE.toString());
        result.setPartitionKeys(MetastoreUtil.getPartitionKeys(table, table.spec().specId()));
        TableMetadata metadata = ((BaseTable)table).operations().current();
        long maxHiveTablePropertySize = conf.getLong("iceberg.hive.table-property-max-size", 32672L);
        HMSTablePropertyHelper.updateHmsTableForIcebergTable(metadata.metadataFileLocation(), result, metadata, null, true, maxHiveTablePropertySize, null);
        String catalogType = CatalogUtils.getCatalogType(conf);
        if (!StringUtils.isEmpty((CharSequence)catalogType) && !"no catalog".equals(catalogType)) {
            result.getParameters().put("type", CatalogUtils.getCatalogType(conf));
        }
        result.setSd(MetastoreUtil.getHiveStorageDescriptor(table));
        return result;
    }

    private static StorageDescriptor getHiveStorageDescriptor(Table table) {
        StorageDescriptor result = new StorageDescriptor();
        result.setCols(HiveSchemaUtil.convert(table.schema()));
        result.setBucketCols((List)Lists.newArrayList());
        result.setNumBuckets(-1);
        result.setSortCols((List)Lists.newArrayList());
        result.setInputFormat(DEFAULT_INPUT_FORMAT_CLASS);
        result.setOutputFormat(DEFAULT_OUTPUT_FORMAT_CLASS);
        result.setSerdeInfo(MetastoreUtil.getHiveSerdeInfo());
        result.setLocation(table.location());
        result.setParameters((Map)Maps.newHashMap());
        result.setSkewedInfo(new SkewedInfo(Collections.emptyList(), Collections.emptyList(), Collections.emptyMap()));
        return result;
    }

    private static SerDeInfo getHiveSerdeInfo() {
        SerDeInfo result = new SerDeInfo("icebergSerde", DEFAULT_SERDE_CLASS, (Map)Maps.newHashMap());
        result.getParameters().put("serialization.format", "1");
        return result;
    }
}

