/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.functions;

import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.txn.jdbc.MultiDataSourceJdbcResource;
import org.apache.hadoop.hive.metastore.txn.jdbc.TransactionalFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class OnRenameFunction
implements TransactionalFunction<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(OnRenameFunction.class);
    private static final String[] UPDATE_COMMANNDS = new String[]{"UPDATE \"TXN_COMPONENTS\" SET \"TC_PARTITION\" = COALESCE(:newPartName, \"TC_PARTITION\"), \"TC_TABLE\" = COALESCE(:newTableName, \"TC_TABLE\"), \"TC_DATABASE\" = COALESCE(:newDbName, \"TC_DATABASE\") WHERE (\"TC_PARTITION\" = :oldPartName OR :oldPartName IS NULL) AND (\"TC_TABLE\" = :oldTableName OR :oldTableName IS NULL) AND (\"TC_DATABASE\" = :oldDbName OR :oldDbName IS NULL)", "UPDATE \"COMPLETED_TXN_COMPONENTS\" SET \"CTC_PARTITION\" = COALESCE(:newPartName, \"CTC_PARTITION\"), \"CTC_TABLE\" = COALESCE(:newTableName, \"CTC_TABLE\"), \"CTC_DATABASE\" = COALESCE(:newDbName, \"CTC_DATABASE\") WHERE (\"CTC_PARTITION\" = :oldPartName OR :oldPartName IS NULL) AND (\"CTC_TABLE\" = :oldTableName OR :oldTableName IS NULL) AND (\"CTC_DATABASE\" = :oldDbName OR :oldDbName IS NULL)", "UPDATE \"HIVE_LOCKS\" SET \"HL_PARTITION\" = COALESCE(:newPartName, \"HL_PARTITION\"), \"HL_TABLE\" = COALESCE(:newTableName, \"HL_TABLE\"), \"HL_DB\" = COALESCE(:newDbName, \"HL_DB\") WHERE (\"HL_PARTITION\" = :oldPartName OR :oldPartName IS NULL) AND (\"HL_TABLE\" = :oldTableName OR :oldTableName IS NULL) AND (\"HL_DB\" = :oldDbName OR :oldDbName IS NULL)", "UPDATE \"COMPACTION_QUEUE\" SET \"CQ_PARTITION\" = COALESCE(:newPartName, \"CQ_PARTITION\"), \"CQ_TABLE\" = COALESCE(:newTableName, \"CQ_TABLE\"), \"CQ_DATABASE\" = COALESCE(:newDbName, \"CQ_DATABASE\") WHERE (\"CQ_PARTITION\" = :oldPartName OR :oldPartName IS NULL) AND (\"CQ_TABLE\" = :oldTableName OR :oldTableName IS NULL) AND (\"CQ_DATABASE\" = :oldDbName OR :oldDbName IS NULL)", "UPDATE \"COMPLETED_COMPACTIONS\" SET \"CC_PARTITION\" = COALESCE(:newPartName, \"CC_PARTITION\"), \"CC_TABLE\" = COALESCE(:newTableName, \"CC_TABLE\"), \"CC_DATABASE\" = COALESCE(:newDbName, \"CC_DATABASE\") WHERE (\"CC_PARTITION\" = :oldPartName OR :oldPartName IS NULL) AND (\"CC_TABLE\" = :oldTableName OR :oldTableName IS NULL) AND (\"CC_DATABASE\" = :oldDbName OR :oldDbName IS NULL)", "UPDATE \"WRITE_SET\" SET \"WS_PARTITION\" = COALESCE(:newPartName, \"WS_PARTITION\"), \"WS_TABLE\" = COALESCE(:newTableName, \"WS_TABLE\"), \"WS_DATABASE\" = COALESCE(:newDbName, \"WS_DATABASE\") WHERE (\"WS_PARTITION\" = :oldPartName OR :oldPartName IS NULL) AND (\"WS_TABLE\" = :oldTableName OR :oldTableName IS NULL) AND (\"WS_DATABASE\" = :oldDbName OR :oldDbName IS NULL)", "UPDATE \"TXN_TO_WRITE_ID\" SET \"T2W_TABLE\" = COALESCE(:newTableName, \"T2W_TABLE\"), \"T2W_DATABASE\" = COALESCE(:newDbName, \"T2W_DATABASE\") WHERE (\"T2W_TABLE\" = :oldTableName OR :oldTableName IS NULL) AND (\"T2W_DATABASE\" = :oldDbName OR :oldDbName IS NULL)", "UPDATE \"NEXT_WRITE_ID\" SET \"NWI_TABLE\" = COALESCE(:newTableName, \"NWI_TABLE\"), \"NWI_DATABASE\" = COALESCE(:newDbName, \"NWI_DATABASE\") WHERE (\"NWI_TABLE\" = :oldTableName OR :oldTableName IS NULL) AND (\"NWI_DATABASE\" = :oldDbName OR :oldDbName IS NULL)", "UPDATE \"COMPACTION_METRICS_CACHE\" SET \"CMC_PARTITION\" = COALESCE(:newPartName, \"CMC_PARTITION\"), \"CMC_TABLE\" = COALESCE(:newTableName, \"CMC_TABLE\"), \"CMC_DATABASE\" = COALESCE(:newDbName, \"CMC_DATABASE\") WHERE (\"CMC_PARTITION\" = :oldPartName OR :oldPartName IS NULL) AND (\"CMC_TABLE\" = :oldTableName OR :oldTableName IS NULL) AND (\"CMC_DATABASE\" = :oldDbName OR :oldDbName IS NULL)"};
    private final String oldCatName;
    private final String oldDbName;
    private final String oldTabName;
    private final String oldPartName;
    private final String newCatName;
    private final String newDbName;
    private final String newTabName;
    private final String newPartName;

    public OnRenameFunction(String oldCatName, String oldDbName, String oldTabName, String oldPartName, String newCatName, String newDbName, String newTabName, String newPartName) {
        this.oldCatName = oldCatName;
        this.oldDbName = StringUtils.lowerCase((String)oldDbName);
        this.oldTabName = StringUtils.lowerCase((String)oldTabName);
        this.oldPartName = oldPartName;
        this.newCatName = newCatName;
        this.newDbName = StringUtils.lowerCase((String)newDbName);
        this.newTabName = StringUtils.lowerCase((String)newTabName);
        this.newPartName = newPartName;
    }

    @Override
    public Void execute(MultiDataSourceJdbcResource jdbcResource) throws MetaException {
        String callSig = "onRename(" + this.oldCatName + "," + this.oldDbName + "," + this.oldTabName + "," + this.oldPartName + "," + this.newCatName + "," + this.newDbName + "," + this.newTabName + "," + this.newPartName + ")";
        if (this.newPartName != null) assert (this.oldPartName != null && this.oldTabName != null && this.oldDbName != null && this.oldCatName != null) : callSig;
        if (this.newTabName != null) assert (this.oldTabName != null && this.oldDbName != null && this.oldCatName != null) : callSig;
        if (this.newDbName != null) assert (this.oldDbName != null && this.oldCatName != null) : callSig;
        MapSqlParameterSource paramSource = new MapSqlParameterSource().addValue("oldDbName", (Object)this.oldDbName, 12).addValue("newDbName", (Object)this.newDbName, 12).addValue("oldTableName", (Object)this.oldTabName, 12).addValue("newTableName", (Object)this.newTabName, 12).addValue("oldPartName", (Object)this.oldPartName, 12).addValue("newPartName", (Object)this.newPartName, 12);
        try {
            for (String command : UPDATE_COMMANNDS) {
                jdbcResource.getJdbcTemplate().update(command, (SqlParameterSource)paramSource);
            }
        }
        catch (DataAccessException e) {
            if (e.getMessage() != null && e.getMessage().contains("does not exist")) {
                LOG.warn("Cannot perform {} since metastore table does not exist", (Object)callSig);
            }
            throw new MetaException("Unable to " + callSig + ":" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
        }
        return null;
    }
}

