/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.functions;

import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.txn.jdbc.MultiDataSourceJdbcResource;
import org.apache.hadoop.hive.metastore.txn.jdbc.TransactionalFunction;
import org.apache.hadoop.hive.metastore.utils.JavaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcquireTxnLockFunction
implements TransactionalFunction<Void> {
    private static final Logger LOG = LoggerFactory.getLogger((String)AcquireTxnLockFunction.class.getName());
    private final boolean shared;

    public AcquireTxnLockFunction(boolean shared) {
        this.shared = shared;
    }

    @Override
    public Void execute(MultiDataSourceJdbcResource jdbcResource) throws MetaException {
        String sqlStmt = jdbcResource.getSqlGenerator().createTxnLockStatement(this.shared);
        jdbcResource.getJdbcTemplate().getJdbcTemplate().execute(stmt -> {
            stmt.execute(sqlStmt);
            return null;
        });
        LOG.debug("TXN lock locked by '{}' in mode {}", (Object)JavaUtils.hostname(), (Object)this.shared);
        return null;
    }
}

