/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.messaging.json.gzip;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.hive.metastore.messaging.AbortTxnMessage;
import org.apache.hadoop.hive.metastore.messaging.AcidWriteMessage;
import org.apache.hadoop.hive.metastore.messaging.AddCheckConstraintMessage;
import org.apache.hadoop.hive.metastore.messaging.AddDefaultConstraintMessage;
import org.apache.hadoop.hive.metastore.messaging.AddForeignKeyMessage;
import org.apache.hadoop.hive.metastore.messaging.AddNotNullConstraintMessage;
import org.apache.hadoop.hive.metastore.messaging.AddPartitionMessage;
import org.apache.hadoop.hive.metastore.messaging.AddPrimaryKeyMessage;
import org.apache.hadoop.hive.metastore.messaging.AddUniqueConstraintMessage;
import org.apache.hadoop.hive.metastore.messaging.AllocWriteIdMessage;
import org.apache.hadoop.hive.metastore.messaging.AlterDatabaseMessage;
import org.apache.hadoop.hive.metastore.messaging.AlterPartitionMessage;
import org.apache.hadoop.hive.metastore.messaging.AlterPartitionsMessage;
import org.apache.hadoop.hive.metastore.messaging.AlterTableMessage;
import org.apache.hadoop.hive.metastore.messaging.CommitCompactionMessage;
import org.apache.hadoop.hive.metastore.messaging.CommitTxnMessage;
import org.apache.hadoop.hive.metastore.messaging.CreateDatabaseMessage;
import org.apache.hadoop.hive.metastore.messaging.CreateFunctionMessage;
import org.apache.hadoop.hive.metastore.messaging.CreateTableMessage;
import org.apache.hadoop.hive.metastore.messaging.DeletePartitionColumnStatMessage;
import org.apache.hadoop.hive.metastore.messaging.DeleteTableColumnStatMessage;
import org.apache.hadoop.hive.metastore.messaging.DropConstraintMessage;
import org.apache.hadoop.hive.metastore.messaging.DropDatabaseMessage;
import org.apache.hadoop.hive.metastore.messaging.DropFunctionMessage;
import org.apache.hadoop.hive.metastore.messaging.DropPartitionMessage;
import org.apache.hadoop.hive.metastore.messaging.DropTableMessage;
import org.apache.hadoop.hive.metastore.messaging.InsertMessage;
import org.apache.hadoop.hive.metastore.messaging.OpenTxnMessage;
import org.apache.hadoop.hive.metastore.messaging.UpdatePartitionColumnStatMessage;
import org.apache.hadoop.hive.metastore.messaging.UpdateTableColumnStatMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONMessageDeserializer;
import org.apache.hadoop.hive.metastore.messaging.json.gzip.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeSerializer
extends JSONMessageDeserializer {
    private static final Logger LOG = LoggerFactory.getLogger((String)Serializer.class.getName());

    /*
     * Enabled aggressive exception aggregation
     */
    private static String deCompress(String messageBody) {
        byte[] decodedBytes = Base64.getDecoder().decode(messageBody.getBytes(StandardCharsets.UTF_8));
        try (ByteArrayInputStream in = new ByteArrayInputStream(decodedBytes);){
            String string;
            try (GZIPInputStream is = new GZIPInputStream(in);){
                byte[] bytes = IOUtils.toByteArray((InputStream)is);
                string = new String(bytes, StandardCharsets.UTF_8);
            }
            return string;
        }
        catch (IOException e) {
            LOG.error("cannot decode the stream", (Throwable)e);
            LOG.debug("base64 encoded String", (Object)messageBody);
            throw new RuntimeException("cannot decode the stream ", e);
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.out.println("Usage:");
            System.out.println("java -cp [classpath] " + DeSerializer.class.getCanonicalName() + " [file_location]");
        }
        System.out.print(DeSerializer.deCompress(FileUtils.readFileToString((File)new File(args[0]), (Charset)StandardCharsets.UTF_8)));
    }

    @Override
    public CreateDatabaseMessage getCreateDatabaseMessage(String messageBody) {
        return super.getCreateDatabaseMessage(DeSerializer.deCompress(messageBody));
    }

    @Override
    public AlterDatabaseMessage getAlterDatabaseMessage(String messageBody) {
        return super.getAlterDatabaseMessage(DeSerializer.deCompress(messageBody));
    }

    @Override
    public DropDatabaseMessage getDropDatabaseMessage(String messageBody) {
        return super.getDropDatabaseMessage(DeSerializer.deCompress(messageBody));
    }

    @Override
    public CreateTableMessage getCreateTableMessage(String messageBody) {
        return super.getCreateTableMessage(DeSerializer.deCompress(messageBody));
    }

    @Override
    public AlterTableMessage getAlterTableMessage(String messageBody) {
        return super.getAlterTableMessage(DeSerializer.deCompress(messageBody));
    }

    @Override
    public DropTableMessage getDropTableMessage(String messageBody) {
        return super.getDropTableMessage(DeSerializer.deCompress(messageBody));
    }

    @Override
    public AddPartitionMessage getAddPartitionMessage(String messageBody) {
        return super.getAddPartitionMessage(DeSerializer.deCompress(messageBody));
    }

    @Override
    public AlterPartitionMessage getAlterPartitionMessage(String messageBody) {
        return super.getAlterPartitionMessage(DeSerializer.deCompress(messageBody));
    }

    @Override
    public AlterPartitionsMessage getAlterPartitionsMessage(String messageBody) {
        return super.getAlterPartitionsMessage(DeSerializer.deCompress(messageBody));
    }

    @Override
    public DropPartitionMessage getDropPartitionMessage(String messageBody) {
        return super.getDropPartitionMessage(DeSerializer.deCompress(messageBody));
    }

    @Override
    public CreateFunctionMessage getCreateFunctionMessage(String messageBody) {
        return super.getCreateFunctionMessage(DeSerializer.deCompress(messageBody));
    }

    @Override
    public DropFunctionMessage getDropFunctionMessage(String messageBody) {
        return super.getDropFunctionMessage(DeSerializer.deCompress(messageBody));
    }

    @Override
    public InsertMessage getInsertMessage(String messageBody) {
        return super.getInsertMessage(DeSerializer.deCompress(messageBody));
    }

    @Override
    public AddPrimaryKeyMessage getAddPrimaryKeyMessage(String messageBody) {
        return super.getAddPrimaryKeyMessage(DeSerializer.deCompress(messageBody));
    }

    @Override
    public AddForeignKeyMessage getAddForeignKeyMessage(String messageBody) {
        return super.getAddForeignKeyMessage(DeSerializer.deCompress(messageBody));
    }

    @Override
    public AddUniqueConstraintMessage getAddUniqueConstraintMessage(String messageBody) {
        return super.getAddUniqueConstraintMessage(DeSerializer.deCompress(messageBody));
    }

    @Override
    public AddDefaultConstraintMessage getAddDefaultConstraintMessage(String messageBody) {
        return super.getAddDefaultConstraintMessage(DeSerializer.deCompress(messageBody));
    }

    @Override
    public AddNotNullConstraintMessage getAddNotNullConstraintMessage(String messageBody) {
        return super.getAddNotNullConstraintMessage(DeSerializer.deCompress(messageBody));
    }

    @Override
    public AddCheckConstraintMessage getAddCheckConstraintMessage(String messageBody) {
        return super.getAddCheckConstraintMessage(DeSerializer.deCompress(messageBody));
    }

    @Override
    public DropConstraintMessage getDropConstraintMessage(String messageBody) {
        return super.getDropConstraintMessage(DeSerializer.deCompress(messageBody));
    }

    @Override
    public OpenTxnMessage getOpenTxnMessage(String messageBody) {
        return super.getOpenTxnMessage(DeSerializer.deCompress(messageBody));
    }

    @Override
    public CommitTxnMessage getCommitTxnMessage(String messageBody) {
        return super.getCommitTxnMessage(DeSerializer.deCompress(messageBody));
    }

    @Override
    public AbortTxnMessage getAbortTxnMessage(String messageBody) {
        return super.getAbortTxnMessage(DeSerializer.deCompress(messageBody));
    }

    @Override
    public AllocWriteIdMessage getAllocWriteIdMessage(String messageBody) {
        return super.getAllocWriteIdMessage(DeSerializer.deCompress(messageBody));
    }

    @Override
    public CommitCompactionMessage getCommitCompactionMessage(String messageBody) {
        return super.getCommitCompactionMessage(DeSerializer.deCompress(messageBody));
    }

    @Override
    public AcidWriteMessage getAcidWriteMessage(String messageBody) {
        return super.getAcidWriteMessage(DeSerializer.deCompress(messageBody));
    }

    @Override
    public UpdateTableColumnStatMessage getUpdateTableColumnStatMessage(String messageBody) {
        return super.getUpdateTableColumnStatMessage(DeSerializer.deCompress(messageBody));
    }

    @Override
    public UpdatePartitionColumnStatMessage getUpdatePartitionColumnStatMessage(String messageBody) {
        return super.getUpdatePartitionColumnStatMessage(DeSerializer.deCompress(messageBody));
    }

    @Override
    public DeleteTableColumnStatMessage getDeleteTableColumnStatMessage(String messageBody) {
        return super.getDeleteTableColumnStatMessage(DeSerializer.deCompress(messageBody));
    }

    @Override
    public DeletePartitionColumnStatMessage getDeletePartitionColumnStatMessage(String messageBody) {
        return super.getDeletePartitionColumnStatMessage(DeSerializer.deCompress(messageBody));
    }

    @Override
    public String deSerializeGenericString(String messageBody) {
        return DeSerializer.deCompress(messageBody);
    }
}

