/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.dataconnector.jdbc;

import org.apache.hadoop.hive.metastore.api.DataConnector;
import org.apache.hadoop.hive.metastore.dataconnector.jdbc.AbstractJDBCConnectorProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MSSQLConnectorProvider
extends AbstractJDBCConnectorProvider {
    private static Logger LOG = LoggerFactory.getLogger(MSSQLConnectorProvider.class);
    private static final String DRIVER_CLASS = "com.microsoft.sqlserver.jdbc.SQLServerDriver".intern();

    public MSSQLConnectorProvider(String dbName, DataConnector dataConn) {
        super(dbName, dataConn, DRIVER_CLASS);
        this.driverClassName = DRIVER_CLASS;
    }

    @Override
    protected String getCatalogName() {
        return null;
    }

    @Override
    protected String getDatabaseName() {
        return this.scoped_db;
    }

    @Override
    protected String getDataType(String dbDataType, int size) {
        Object mappedType = super.getDataType(dbDataType, size);
        if (!((String)mappedType).equalsIgnoreCase("void")) {
            return mappedType;
        }
        switch (dbDataType.toLowerCase()) {
            case "nvarchar": 
            case "nchar": {
                mappedType = "varchar" + this.wrapSize(size);
                break;
            }
            case "bit": {
                mappedType = "boolean";
                break;
            }
            case "number": {
                mappedType = "int";
                break;
            }
            default: {
                mappedType = "void";
            }
        }
        return mappedType;
    }
}

