/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.DefaultPartitionExpressionProxy;
import org.apache.hadoop.hive.metastore.PartitionExpressionProxy;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.parser.ExpressionTree;
import org.apache.hadoop.hive.metastore.parser.PartFilterParser;
import org.apache.hadoop.hive.metastore.utils.JavaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartFilterExprUtil {
    private static final Logger LOG = LoggerFactory.getLogger((String)PartFilterExprUtil.class.getName());

    public static ExpressionTree makeExpressionTree(PartitionExpressionProxy expressionProxy, byte[] expr, String defaultPartitionName, Configuration conf) throws MetaException {
        String filter = null;
        try {
            filter = expressionProxy.convertExprToFilter(expr, defaultPartitionName, conf.getBoolean(MetastoreConf.ConfVars.DECODE_FILTER_EXPRESSION_TO_STRING.getVarname(), false));
        }
        catch (MetaException ex) {
            Class exClass = JavaUtils.getClass((String)"org.apache.hadoop.hive.metastore.IMetaStoreClient$IncompatibleMetastoreException", MetaException.class);
            throw (MetaException)((Object)JavaUtils.newInstance((Class)exClass, (Class[])new Class[]{String.class}, (Object[])new Object[]{ex.getMessage()}));
        }
        return PartFilterExprUtil.makeExpressionTree(filter);
    }

    public static PartitionExpressionProxy createExpressionProxy(Configuration conf) {
        String className = MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.EXPRESSION_PROXY_CLASS);
        try {
            Class clazz = JavaUtils.getClass((String)className, PartitionExpressionProxy.class);
            return (PartitionExpressionProxy)JavaUtils.newInstance((Class)clazz, (Class[])new Class[0], (Object[])new Object[0]);
        }
        catch (MetaException e) {
            if (e.getMessage().matches(".* class not found")) {
                return new DefaultPartitionExpressionProxy();
            }
            LOG.error("Error loading PartitionExpressionProxy", (Throwable)e);
            throw new RuntimeException("Error loading PartitionExpressionProxy: " + e.getMessage());
        }
    }

    private static ExpressionTree makeExpressionTree(String filter) throws MetaException {
        if (filter == null || filter.isEmpty()) {
            return ExpressionTree.EMPTY_TREE;
        }
        LOG.debug("Filter specified is " + filter);
        ExpressionTree tree = null;
        try {
            tree = PartFilterExprUtil.parseFilterTree(filter);
        }
        catch (MetaException ex) {
            LOG.info("Unable to make the expression tree from expression string [" + filter + "]" + ex.getMessage());
        }
        return tree;
    }

    public static ExpressionTree parseFilterTree(String filter) throws MetaException {
        return PartFilterParser.parseFilter(filter);
    }
}

