/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo.columns;

import com.google.common.base.Preconditions;
import org.apache.hadoop.hive.accumulo.columns.ColumnEncoding;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public abstract class ColumnMapping {
    protected final String mappingSpec;
    protected final ColumnEncoding encoding;
    protected final String columnName;
    protected final String columnType;

    protected ColumnMapping(String mappingSpec, ColumnEncoding encoding, String columnName, String columnType) {
        Preconditions.checkNotNull((Object)mappingSpec);
        Preconditions.checkNotNull((Object)((Object)encoding));
        Preconditions.checkNotNull((Object)columnName);
        Preconditions.checkNotNull((Object)columnType);
        this.mappingSpec = mappingSpec;
        this.encoding = encoding;
        this.columnName = columnName;
        this.columnType = columnType;
    }

    protected ColumnMapping(String mappingSpec, ColumnEncoding encoding, String columnName, TypeInfo columnType) {
        Preconditions.checkNotNull((Object)mappingSpec);
        Preconditions.checkNotNull((Object)((Object)encoding));
        Preconditions.checkNotNull((Object)columnName);
        Preconditions.checkNotNull((Object)columnType);
        this.mappingSpec = mappingSpec;
        this.encoding = encoding;
        this.columnName = columnName;
        this.columnType = columnType.getTypeName();
    }

    public String getMappingSpec() {
        return this.mappingSpec;
    }

    public ColumnEncoding getEncoding() {
        return this.encoding;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getColumnType() {
        return this.columnType;
    }
}

