/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.impexp;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.StringUtils;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class AttributeTransform
implements Serializable {
    private Map<String, String> conditions;
    private Map<String, String> action;

    public AttributeTransform() {
    }

    public AttributeTransform(Map<String, String> conditions, Map<String, String> action) {
        this.conditions = conditions;
        this.action = action;
    }

    public Map<String, String> getConditions() {
        return this.conditions;
    }

    public void setConditions(Map<String, String> conditions) {
        this.conditions = conditions;
    }

    public Map<String, String> getAction() {
        return this.action;
    }

    public void setAction(Map<String, String> action) {
        this.action = action;
    }

    public void addCondition(String attributeName, String conditionValue) {
        if (this.conditions == null) {
            this.conditions = new HashMap<String, String>();
        }
        if (StringUtils.isNotEmpty((String)attributeName) && StringUtils.isNotEmpty((String)conditionValue)) {
            this.conditions.put(attributeName, conditionValue);
        }
    }

    public void addAction(String attributeName, String actionValue) {
        if (this.action == null) {
            this.action = new HashMap<String, String>();
        }
        if (StringUtils.isNotEmpty((String)attributeName) && StringUtils.isNotEmpty((String)actionValue)) {
            this.action.put(attributeName, actionValue);
        }
    }
}

