/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.operation;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.ql.QueryInfo;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.ShowProcessListProcessor;
import org.apache.hadoop.hive.ql.session.ProcessListInfo;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.operation.HiveCommandOperation;
import org.apache.hive.service.cli.operation.Operation;
import org.apache.hive.service.cli.operation.SQLOperation;
import org.apache.hive.service.cli.session.HiveSession;
import org.apache.hive.service.cli.session.SessionManager;

public class ShowProcessListOperation
extends HiveCommandOperation {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");

    protected ShowProcessListOperation(HiveSession parentSession, String statement, CommandProcessor commandProcessor, Map<String, String> confOverlay) {
        super(parentSession, statement, commandProcessor, confOverlay);
    }

    @Override
    public void runInternal() throws HiveSQLException {
        List<ProcessListInfo> liveQueries = this.getLiveQueryInfos(this.parentSession);
        ShowProcessListProcessor showProcesslistProcessor = (ShowProcessListProcessor)this.commandProcessor;
        if (liveQueries != null) {
            showProcesslistProcessor.setup(liveQueries);
        }
        super.runInternal();
    }

    private List<ProcessListInfo> getLiveQueryInfos(HiveSession parentSession) {
        SessionManager sessionManager = parentSession.getSessionManager();
        if (sessionManager == null) {
            return null;
        }
        long currentTime = System.currentTimeMillis();
        Collection<Operation> operations = sessionManager.getOperations();
        return operations.stream().filter(op -> op instanceof SQLOperation).map(op -> {
            HiveSession session = op.getParentSession();
            QueryInfo query = sessionManager.getOperationManager().getQueryInfo(op.getHandle().getHandleIdentifier().toString());
            LocalDateTime beginTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(query.getBeginTime()), ZoneId.systemDefault());
            long txnId = 0L;
            if (op.queryState != null && op.queryState.getTxnManager() != null) {
                txnId = op.queryState.getTxnManager().getCurrentTxnId();
            }
            return new ProcessListInfo.Builder().setUserName(session.getUserName()).setIpAddr(session.getIpAddress()).setSessionId(session.getSessionHandle().getHandleIdentifier().toString()).setSessionActiveTime((currentTime - session.getCreationTime()) / 1000L).setSessionIdleTime((currentTime - session.getLastAccessTime()) / 1000L).setQueryId(op.getQueryId()).setExecutionEngine(query.getExecutionEngine()).setBeginTime(beginTime.format(FORMATTER)).setRuntime(query.getRuntime() == null ? "Not finished" : String.valueOf(query.getRuntime() / 1000L)).setElapsedTime(query.getElapsedTime() / 1000L).setState(query.getState()).setTxnId(txnId).build();
        }).collect(Collectors.toList());
    }
}

