/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.cpc;

import java.util.Arrays;
import java.util.List;
import org.apache.datasketches.cpc.CpcSketch;
import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.memory.Memory;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.BytesWritable;

@Description(name="GetEstimateAndBounds", value="_FUNC_(sketch, kappa, seed)", extended="Returns an estimate and bounds of unique count from a given CpcSketch. The result is three double values: estimate, lower bound and upper bound. Optional kappa is a number of standard deviations from the mean: 1, 2 or 3 (default 2). The seed is optional. It is needed if the sketch was created with a custom seed.")
public class GetEstimateAndErrorBoundsUDF
extends UDF {
    private static final int DEFAULT_KAPPA = 2;

    public List<Double> evaluate(BytesWritable serializedSketch) {
        return this.evaluate(serializedSketch, 2, 9001L);
    }

    public List<Double> evaluate(BytesWritable serializedSketch, int kappa) {
        return this.evaluate(serializedSketch, kappa, 9001L);
    }

    public List<Double> evaluate(BytesWritable serializedSketch, int kappa, long seed) {
        if (serializedSketch == null) {
            return null;
        }
        CpcSketch sketch = CpcSketch.heapify((Memory)BytesWritableHelper.wrapAsMemory(serializedSketch), (long)seed);
        return Arrays.asList(sketch.getEstimate(), sketch.getLowerBound(kappa), sketch.getUpperBound(kappa));
    }
}

